<?xml version="1.0" encoding="UTF-8"?>
<StyledLayerDescriptor 
  version="1.0.0"
  xsi:schemaLocation="http://www.opengis.net/sld http://schemas.opengis.net/sld/1.0.0/StyledLayerDescriptor.xsd"
  xmlns="http://www.opengis.net/sld" 
  xmlns:ogc="http://www.opengis.net/ogc"
  xmlns:xlink="http://www.w3.org/1999/xlink" 
  xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">

	<NamedLayer>
		<Name>hame_viivat</Name>
		<UserStyle>
			<Name>hame_viivat</Name>
			<Title>Viivamaiset merkinnät ja niiden labelit</Title>
			<FeatureTypeStyle>			
				<Rule>
					<Title>Yhdyskuntarakenteen laajenemissuunta</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>5</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>	
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#dfbf8f</CssParameter>
							<CssParameter name="stroke-width">2.666667</CssParameter> 
						</Stroke>
					</LineSymbolizer>

					<PointSymbolizer>
						<Geometry>
							<ogc:Function name="endPoint">
								<ogc:PropertyName>geom</ogc:PropertyName>
							</ogc:Function>
						</Geometry>
						<Graphic>
							<Mark>
								<WellKnownName>shape://oarrow</WellKnownName>
								<Fill>
									<CssParameter name="fill">#dfbf8f</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#dfbf8f</CssParameter>
									<CssParameter name="stroke-width">2</CssParameter>
								</Stroke>
							</Mark>
							<Size>30</Size>
							<Rotation>
								<ogc:Function name="endAngle">
									<ogc:PropertyName>geom</ogc:PropertyName>
								</ogc:Function>
							</Rotation>
						</Graphic>
					</PointSymbolizer>
				</Rule>
				
				<Rule>
					<Title>Yhdyskuntarakenteen eheyttämistarve</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>6</ogc:Literal>
						</ogc:PropertyIsEqualTo>                       
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>					
					<LineSymbolizer>
					<Stroke>
						<GraphicStroke>
							  <Graphic>
								<Mark>
									<WellKnownName>extshape://arrow?hr=1.2&amp;t=0.2&amp;ab=0.5</WellKnownName>
								  <Fill>
									<CssParameter name="fill">#0000ff</CssParameter>
								  </Fill>
								  <Stroke>
									<CssParameter name="stroke">#000000</CssParameter>
									<CssParameter name="stroke-width">1</CssParameter>
									<CssParameter name="stroke-dasharray">8.333333 4</CssParameter>
								  </Stroke>
								</Mark>
								<Size>6</Size>
							  </Graphic>
							</GraphicStroke>
						  </Stroke>
				  </LineSymbolizer>
				</Rule>				

				<Rule>
					<Title>Tieliikenteen yhteystarve</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>8</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>	
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#f40a27</CssParameter>
							<CssParameter name="stroke-width">2.666667</CssParameter> 
							<CssParameter name="stroke-dasharray">5.333333 3</CssParameter>
						</Stroke>
					</LineSymbolizer>
					<PointSymbolizer>
						<Geometry>
							<ogc:Function name="startPoint">
								<ogc:PropertyName>geom</ogc:PropertyName>
							</ogc:Function>
						</Geometry>
						<Graphic>
							<Mark>
								<WellKnownName>shape://oarrow</WellKnownName>
								<Fill>
									<CssParameter name="fill">#f40a28</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#f40a28</CssParameter>
									<CssParameter name="stroke-width">2</CssParameter>
								</Stroke>
							</Mark>
							<Size>30</Size>
							<Rotation> 
								<ogc:Add> 
									<ogc:Function name="startAngle"> 
										<ogc:PropertyName>geom</ogc:PropertyName> 
									</ogc:Function> 
									<ogc:Literal>180.0</ogc:Literal> 
								</ogc:Add> 
							</Rotation>
						</Graphic>
					</PointSymbolizer>
					<PointSymbolizer>
						<Geometry>
							<ogc:Function name="endPoint">
								<ogc:PropertyName>geom</ogc:PropertyName>
							</ogc:Function>
						</Geometry>
						<Graphic>
							<Mark>
								<WellKnownName>shape://oarrow</WellKnownName>
								<Fill>
									<CssParameter name="fill">#f40a28</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#f40a28</CssParameter>
									<CssParameter name="stroke-width">2</CssParameter>
								</Stroke>
							</Mark>
							<Size>30</Size>
							<Rotation>
								<ogc:Function name="endAngle">
									<ogc:PropertyName>geom</ogc:PropertyName>
								</ogc:Function>
							</Rotation>
						</Graphic>
					</PointSymbolizer>
				</Rule>

				<Rule>
					<Title>Joukkoliikenteen kehittämiskäytävä/yhteystarve</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>9</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>	
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#000000</CssParameter>
							<CssParameter name="stroke-width">2.666667</CssParameter> 
							<CssParameter name="stroke-dasharray">5.333333 3</CssParameter>
						</Stroke>
					</LineSymbolizer>
					<PointSymbolizer>
						<Geometry>
							<ogc:Function name="startPoint">
								<ogc:PropertyName>geom</ogc:PropertyName>
							</ogc:Function>
						</Geometry>
						<Graphic>
							<Mark>
								<WellKnownName>shape://oarrow</WellKnownName>
								<Fill>
									<CssParameter name="fill">#000000</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#000000</CssParameter>
									<CssParameter name="stroke-width">2</CssParameter>
								</Stroke>
							</Mark>
							<Size>30</Size>
							<Rotation> 
								<ogc:Add> 
									<ogc:Function name="startAngle"> 
										<ogc:PropertyName>geom</ogc:PropertyName> 
									</ogc:Function> 
									<ogc:Literal>180.0</ogc:Literal> 
								</ogc:Add> 
							</Rotation>
						</Graphic>
					</PointSymbolizer>
					<PointSymbolizer>
						<Geometry>
							<ogc:Function name="endPoint">
								<ogc:PropertyName>geom</ogc:PropertyName>
							</ogc:Function>
						</Geometry>
						<Graphic>
							<Mark>
								<WellKnownName>shape://oarrow</WellKnownName>
								<Fill>
									<CssParameter name="fill">#000000</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#000000</CssParameter>
									<CssParameter name="stroke-width">2</CssParameter>
								</Stroke>
							</Mark>
							<Size>30</Size>
							<Rotation>
								<ogc:Function name="endAngle">
									<ogc:PropertyName>geom</ogc:PropertyName>
								</ogc:Function>
							</Rotation>
						</Graphic>
					</PointSymbolizer>
					</Rule>
					<Rule>
					<Title>Joukkoliikenteen kehittämiskäytävä/yhteystarve label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>9</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>200000</MaxScaleDenominator>	
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.0</AnchorPointX>
									<AnchorPointY>0.0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#000000</CssParameter>
						</Fill>
					</TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Kevyen liikenteen yhteystarve</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>90</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>	
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#9b4f00</CssParameter>
							<CssParameter name="stroke-width">2.666667</CssParameter> 
							<CssParameter name="stroke-dasharray">5.333333 3</CssParameter>
						</Stroke>
					</LineSymbolizer>
					<PointSymbolizer>
						<Geometry>
							<ogc:Function name="startPoint">
								<ogc:PropertyName>geom</ogc:PropertyName>
							</ogc:Function>
						</Geometry>
						<Graphic>
							<Mark>
								<WellKnownName>shape://oarrow</WellKnownName>
								<Fill>
									<CssParameter name="fill">#9b4f00</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#9b4f00</CssParameter>
									<CssParameter name="stroke-width">2</CssParameter>
								</Stroke>
							</Mark>
							<Size>30</Size>
							<Rotation> 
								<ogc:Add> 
									<ogc:Function name="startAngle"> 
										<ogc:PropertyName>geom</ogc:PropertyName> 
									</ogc:Function> 
									<ogc:Literal>180.0</ogc:Literal> 
								</ogc:Add> 
							</Rotation>
						</Graphic>
					</PointSymbolizer>
					<PointSymbolizer>
						<Geometry>
							<ogc:Function name="endPoint">
								<ogc:PropertyName>geom</ogc:PropertyName>
							</ogc:Function>
						</Geometry>
						<Graphic>
							<Mark>
								<WellKnownName>shape://oarrow</WellKnownName>
								<Fill>
									<CssParameter name="fill">#9b4f00</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#9b4f00</CssParameter>
									<CssParameter name="stroke-width">2</CssParameter>
								</Stroke>
							</Mark>
							<Size>30</Size>
							<Rotation>
								<ogc:Function name="endAngle">
									<ogc:PropertyName>geom</ogc:PropertyName>
								</ogc:Function>
							</Rotation>
						</Graphic>
					</PointSymbolizer>
				</Rule>
				<Rule>
					<Title>Kevyen liikenteen yhteystarve label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>90</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>200000</MaxScaleDenominator>					
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.0</AnchorPointX>
									<AnchorPointY>0.0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#9b4f00</CssParameter>
						</Fill>
					</TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Viheryhteystarve</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>10</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>	
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#54a81c</CssParameter>
							<CssParameter name="stroke-width">2.666667</CssParameter> 
							<CssParameter name="stroke-dasharray">5.333333 3</CssParameter>
						</Stroke>
					</LineSymbolizer>
					<PointSymbolizer>
						<Geometry>
							<ogc:Function name="startPoint">
								<ogc:PropertyName>geom</ogc:PropertyName>
							</ogc:Function>
						</Geometry>
						<Graphic>
							<Mark>
								<WellKnownName>shape://oarrow</WellKnownName>
								<Fill>
									<CssParameter name="fill">#54a81c</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#54a81c</CssParameter>
									<CssParameter name="stroke-width">2</CssParameter>
								</Stroke>
							</Mark>
							<Size>30</Size>
							<Rotation> 
								<ogc:Add> 
									<ogc:Function name="startAngle"> 
										<ogc:PropertyName>geom</ogc:PropertyName> 
									</ogc:Function> 
									<ogc:Literal>180.0</ogc:Literal> 
								</ogc:Add> 
							</Rotation>
						</Graphic>
					</PointSymbolizer>
					<PointSymbolizer>
						<Geometry>
							<ogc:Function name="endPoint">
								<ogc:PropertyName>geom</ogc:PropertyName>
							</ogc:Function>
						</Geometry>
						<Graphic>
							<Mark>
								<WellKnownName>shape://oarrow</WellKnownName>
								<Fill>
									<CssParameter name="fill">#54a81c</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#54a81c</CssParameter>
									<CssParameter name="stroke-width">2</CssParameter>
								</Stroke>
							</Mark>
							<Size>30</Size>
							<Rotation>
								<ogc:Function name="endAngle">
									<ogc:PropertyName>geom</ogc:PropertyName>
								</ogc:Function>
							</Rotation>
						</Graphic>
					</PointSymbolizer>
				</Rule>

				<Rule>
					<Title>Vesiliikenteen yhteystarve</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>91</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>	
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#003ebe</CssParameter>
							<CssParameter name="stroke-width">2.666667</CssParameter> 
							<CssParameter name="stroke-dasharray">5.333333 3</CssParameter>
						</Stroke>
					</LineSymbolizer>
					<PointSymbolizer>
						<Geometry>
							<ogc:Function name="startPoint">
								<ogc:PropertyName>geom</ogc:PropertyName>
							</ogc:Function>
						</Geometry>
						<Graphic>
							<Mark>
								<WellKnownName>shape://oarrow</WellKnownName>
								<Fill>
									<CssParameter name="fill">#003ebe</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#003ebe</CssParameter>
									<CssParameter name="stroke-width">2</CssParameter>
								</Stroke>
							</Mark>
							<Size>30</Size>
							<Rotation> 
								<ogc:Add> 
									<ogc:Function name="startAngle"> 
										<ogc:PropertyName>geom</ogc:PropertyName> 
									</ogc:Function> 
									<ogc:Literal>180.0</ogc:Literal> 
								</ogc:Add> 
							</Rotation>
						</Graphic>
					</PointSymbolizer>
					<PointSymbolizer>
						<Geometry>
							<ogc:Function name="endPoint">
								<ogc:PropertyName>geom</ogc:PropertyName>
							</ogc:Function>
						</Geometry>
						<Graphic>
							<Mark>
								<WellKnownName>shape://oarrow</WellKnownName>
								<Fill>
									<CssParameter name="fill">#003ebe</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#003ebe</CssParameter>
									<CssParameter name="stroke-width">2</CssParameter>
								</Stroke>
							</Mark>
							<Size>30</Size>
							<Rotation>
								<ogc:Function name="endAngle">
									<ogc:PropertyName>geom</ogc:PropertyName>
								</ogc:Function>
							</Rotation>
						</Graphic>
					</PointSymbolizer>
				</Rule>

				<Rule>
					<Title>Raideliikenteen yhteystarve</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>92</ogc:Literal>
							<!-- ? -->
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#ff0000</CssParameter>
							<CssParameter name="stroke-width">2.666667</CssParameter> 
							<CssParameter name="stroke-dasharray">10.666667 5.333333</CssParameter>
						</Stroke>
					</LineSymbolizer>
					<LineSymbolizer>
						<Stroke>
							<GraphicStroke>
								<Graphic>
									<Mark>
										<WellKnownName>shape://vertline</WellKnownName>
										<Stroke>
											<CssParameter name="stroke">#ff0000</CssParameter>
											<CssParameter name="stroke-width">1.333333</CssParameter>
										</Stroke>
									</Mark>
									<Size>10.666667</Size>
								</Graphic>
							</GraphicStroke>
						</Stroke>
					</LineSymbolizer>
					<PointSymbolizer>
						<Geometry>
							<ogc:Function name="startPoint">
								<ogc:PropertyName>geom</ogc:PropertyName>
							</ogc:Function>
						</Geometry>
						<Graphic>
							<Mark>
								<WellKnownName>shape://oarrow</WellKnownName>
								<Fill>
									<CssParameter name="fill">#ff0000</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#ff0000</CssParameter>
									<CssParameter name="stroke-width">2</CssParameter>
								</Stroke>
							</Mark>
							<Size>30</Size>
							<Rotation> 
								<ogc:Add> 
									<ogc:Function name="startAngle"> 
										<ogc:PropertyName>geom</ogc:PropertyName> 
									</ogc:Function> 
									<ogc:Literal>180.0</ogc:Literal> 
								</ogc:Add> 
							</Rotation>
						</Graphic>
					</PointSymbolizer>	
					<PointSymbolizer>
						<Geometry>
							<ogc:Function name="endPoint">
								<ogc:PropertyName>geom</ogc:PropertyName>
							</ogc:Function>
						</Geometry>
						<Graphic>
							<Mark>
								<WellKnownName>shape://oarrow</WellKnownName>
								<Fill>
									<CssParameter name="fill">#ff0000</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#ff0000</CssParameter>
									<CssParameter name="stroke-width">2</CssParameter>
								</Stroke>
							</Mark>
							<Size>30</Size>
							<Rotation>
								<ogc:Function name="endAngle">
									<ogc:PropertyName>geom</ogc:PropertyName>
								</ogc:Function>
							</Rotation>
						</Graphic>
					</PointSymbolizer>
				</Rule>

				<Rule>
					<Title>Natura 2000-verkostoon kuuluva tai ehdotettu alue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>14</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>	
					<LineSymbolizer>
						<Stroke>
							<GraphicStroke>
								<Graphic>
									<Mark>
										<WellKnownName>circle</WellKnownName>
										<Fill>
											<CssParameter name="fill">#9c9c9c</CssParameter>
										</Fill>
									</Mark>
									<Size>6</Size>
								</Graphic>
							</GraphicStroke>
							<CssParameter name="stroke-dasharray">6 2</CssParameter>
						</Stroke>
					</LineSymbolizer>
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#9c9c9c</CssParameter>
							<CssParameter name="stroke-width">1.333333</CssParameter> 
						</Stroke>
					</LineSymbolizer>
					</Rule>
					<Rule>
					<Title>Natura 2000-verkostoon kuuluva tai ehdotettu alue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>14</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>200000</MaxScaleDenominator>	
					<TextSymbolizer>
						<Label>
							nat
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.0</AnchorPointX>
									<AnchorPointY>0.0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#9c9c9c</CssParameter>
						</Fill>
					</TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Unescon maailmanperintökohde</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>16</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>	
					<LineSymbolizer>
						<Stroke>
							<GraphicStroke>
								<Graphic>
									<Mark>
										<WellKnownName>circle</WellKnownName>
										<Fill>
											<CssParameter name="fill">#000000</CssParameter>
										</Fill>
									</Mark>
									<Size>6</Size>
								</Graphic>
							</GraphicStroke>
							<CssParameter name="stroke-dasharray">6 2</CssParameter>
						</Stroke>
					</LineSymbolizer>
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#000000</CssParameter>
							<CssParameter name="stroke-width">1.333333</CssParameter> 
						</Stroke>
					</LineSymbolizer>
					</Rule>
					<Rule>
					<Title>Unescon maailmanperintökohde label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>16</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>200000</MaxScaleDenominator>	
					<TextSymbolizer>
						<Label>
							un
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.0</AnchorPointX>
									<AnchorPointY>0.0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#000000</CssParameter>
						</Fill>
					</TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Kansallinen kaupunkipuisto</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>17</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>	
					<LineSymbolizer>
						<Stroke>
							<GraphicStroke>
								<Graphic>
									<Mark>
										<WellKnownName>circle</WellKnownName>
										<Fill>
											<CssParameter name="fill">#006d00</CssParameter>
										</Fill>
									</Mark>
									<Size>6</Size>
								</Graphic>
							</GraphicStroke>
							<CssParameter name="stroke-dasharray">6 2</CssParameter>
						</Stroke>
					</LineSymbolizer>
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#006d00</CssParameter>
							<CssParameter name="stroke-width">1.333333</CssParameter> 
						</Stroke>
					</LineSymbolizer>
					</Rule>
					<Rule>
					<Title>Kansallinen kaupunkipuisto label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>17</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>200000</MaxScaleDenominator>	
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.0</AnchorPointX>
									<AnchorPointY>0.0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#006d00</CssParameter>
						</Fill>
					</TextSymbolizer>
				</Rule>

				<!-- Kohde- ja viivamerkinn?t -->

				<Rule>
					<Title>Moottori- tai moottoriliikennetie</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>69</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>	
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#000000</CssParameter>
							<CssParameter name="stroke-width">9.333333</CssParameter> 
						</Stroke>
					</LineSymbolizer>
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#ffffff</CssParameter>
							<CssParameter name="stroke-width">4</CssParameter> 
						</Stroke>
					</LineSymbolizer>
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#000000</CssParameter>
							<CssParameter name="stroke-width">0.666667</CssParameter> 
						</Stroke>
					</LineSymbolizer>
					</Rule>
					<Rule>
					<Title>Moottori- tai moottoriliikennetie label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>69</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>200000</MaxScaleDenominator>	
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#000000</CssParameter>
						</Fill>
					</TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Moottori- tai moottoriliikennetie, parannettava</Title>
					<ogc:Filter>
						<ogc:And>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
								<ogc:Literal>69</ogc:Literal>
							</ogc:PropertyIsEqualTo>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>merkLisati</ogc:PropertyName>
								<ogc:Literal>parannettava</ogc:Literal>
							</ogc:PropertyIsEqualTo>
						</ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>	
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#f40a27</CssParameter>
							<CssParameter name="stroke-width">9.333333</CssParameter> 
						</Stroke>
					</LineSymbolizer>
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#ffffff</CssParameter>
							<CssParameter name="stroke-width">4</CssParameter> 
						</Stroke>
					</LineSymbolizer>
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#f40a27</CssParameter>
							<CssParameter name="stroke-width">0.666667</CssParameter> 
						</Stroke>
					</LineSymbolizer>
					</Rule>
					<Rule>
					<Title>Moottori- tai moottoriliikennetie, parannettava label</Title>
					<ogc:Filter>
						<ogc:And>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
								<ogc:Literal>69</ogc:Literal>
							</ogc:PropertyIsEqualTo>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>merkLisati</ogc:PropertyName>
								<ogc:Literal>parannettava</ogc:Literal>
							</ogc:PropertyIsEqualTo>
						</ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>200000</MaxScaleDenominator>	
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#f40a27</CssParameter>
						</Fill>
					</TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Moottori- tai moottoriliikennetie, ohjeellinen</Title>
					<ogc:Filter>
						<ogc:And>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
								<ogc:Literal>69</ogc:Literal>
							</ogc:PropertyIsEqualTo>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>merkLisati</ogc:PropertyName>
								<ogc:Literal>ohjeellinen</ogc:Literal>
							</ogc:PropertyIsEqualTo>
						</ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>	
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#f40a27</CssParameter>
							<CssParameter name="stroke-width">9.333333</CssParameter> 
							<CssParameter name="stroke-dasharray">6.666667 3.333333</CssParameter>
						</Stroke>
					</LineSymbolizer>
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#ffffff</CssParameter>
							<CssParameter name="stroke-width">4</CssParameter> 
							<CssParameter name="stroke-dasharray">6.666667 3.333333</CssParameter>
						</Stroke>
					</LineSymbolizer>
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#f40a27</CssParameter>
							<CssParameter name="stroke-width">0.666667</CssParameter> 
							<CssParameter name="stroke-dasharray">6.666667 3.333333</CssParameter>
						</Stroke>
					</LineSymbolizer>
					</Rule>
					<Rule>
					<Title>Moottori- tai moottoriliikennetie, ohjeellinen label</Title>
					<ogc:Filter>
						<ogc:And>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
								<ogc:Literal>69</ogc:Literal>
							</ogc:PropertyIsEqualTo>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>merkLisati</ogc:PropertyName>
								<ogc:Literal>ohjeellinen</ogc:Literal>
							</ogc:PropertyIsEqualTo>
						</ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>200000</MaxScaleDenominator>	
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#f40a27</CssParameter>
						</Fill>
					</TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Kaksiajoratainen päätie tai -katu</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>70</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>	
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#000000</CssParameter>
							<CssParameter name="stroke-width">6.666667</CssParameter> 
						</Stroke>
					</LineSymbolizer>
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#ffffff</CssParameter>
							<CssParameter name="stroke-width">1.333333</CssParameter> 
						</Stroke>
					</LineSymbolizer>
					</Rule>
					<Rule>
					<Title>Kaksiajoratainen päätie tai -katu label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>70</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>200000</MaxScaleDenominator>	
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#000000</CssParameter>
						</Fill>
					</TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Kaksiajoratainen päätie tai -katu, parannettava</Title>
					<ogc:Filter>
						<ogc:And>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
								<ogc:Literal>70</ogc:Literal>
							</ogc:PropertyIsEqualTo>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>merkLisati</ogc:PropertyName>
								<ogc:Literal>parannettava</ogc:Literal>
							</ogc:PropertyIsEqualTo>
						</ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>	
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#f40a27</CssParameter>
							<CssParameter name="stroke-width">6.666667</CssParameter> 
						</Stroke>
					</LineSymbolizer>
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#ffffff</CssParameter>
							<CssParameter name="stroke-width">1.333333</CssParameter> 
						</Stroke>
					</LineSymbolizer>
					</Rule>
					<Rule>
					<Title>Kaksiajoratainen päätie tai -katu, parannettava label</Title>
					<ogc:Filter>
						<ogc:And>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
								<ogc:Literal>70</ogc:Literal>
							</ogc:PropertyIsEqualTo>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>merkLisati</ogc:PropertyName>
								<ogc:Literal>parannettava</ogc:Literal>
							</ogc:PropertyIsEqualTo>
						</ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>200000</MaxScaleDenominator>	
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#f40a27</CssParameter>
						</Fill>
					</TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Kaksiajoratainen päätie tai -katu, ohjeellinen</Title>
					<ogc:Filter>
						<ogc:And>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
								<ogc:Literal>70</ogc:Literal>
							</ogc:PropertyIsEqualTo>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>merkLisati</ogc:PropertyName>
								<ogc:Literal>ohjeellinen</ogc:Literal>
							</ogc:PropertyIsEqualTo>
						</ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>	
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#f40a27</CssParameter>
							<CssParameter name="stroke-width">6.666667</CssParameter> 
							<CssParameter name="stroke-dasharray">6.666667 3.333333</CssParameter>
						</Stroke>
					</LineSymbolizer>
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#ffffff</CssParameter>
							<CssParameter name="stroke-width">1.333333</CssParameter> 
							<CssParameter name="stroke-dasharray">6.666667 3.333333</CssParameter>
						</Stroke>
					</LineSymbolizer>
					</Rule>
					<Rule>
					<Title>Kaksiajoratainen päätie tai -katu, ohjeellinen label</Title>
					<ogc:Filter>
						<ogc:And>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
								<ogc:Literal>70</ogc:Literal>
							</ogc:PropertyIsEqualTo>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>merkLisati</ogc:PropertyName>
								<ogc:Literal>ohjeellinen</ogc:Literal>
							</ogc:PropertyIsEqualTo>
						</ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>200000</MaxScaleDenominator>	
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#f40a27</CssParameter>
						</Fill>
					</TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Valtatie/kantatie</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>71</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>	
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#000000</CssParameter>
							<CssParameter name="stroke-width">5.333333</CssParameter> 
						</Stroke>
					</LineSymbolizer>
					</Rule>
					<Rule>
					<Title>Valtatie/kantatie label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>71</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>200000</MaxScaleDenominator>	
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#000000</CssParameter>
						</Fill>
					</TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Valtatie/kantatie, parannettava</Title>
					<ogc:Filter>
						<ogc:And>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
								<ogc:Literal>71</ogc:Literal>
							</ogc:PropertyIsEqualTo>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>merkLisati</ogc:PropertyName>
								<ogc:Literal>parannettava</ogc:Literal>
							</ogc:PropertyIsEqualTo>
						</ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>	
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#f40a27</CssParameter>
							<CssParameter name="stroke-width">5.333333</CssParameter> 
						</Stroke>
					</LineSymbolizer>
					</Rule>
					<Rule>
					<Title>Valtatie/kantatie, parannettava label</Title>
					<ogc:Filter>
						<ogc:And>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
								<ogc:Literal>71</ogc:Literal>
							</ogc:PropertyIsEqualTo>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>merkLisati</ogc:PropertyName>
								<ogc:Literal>parannettava</ogc:Literal>
							</ogc:PropertyIsEqualTo>
						</ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>200000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#f40a27</CssParameter>
						</Fill>
					</TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Valtatie/kantatie, ohjeellinen</Title>
					<ogc:Filter>
						<ogc:And>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
								<ogc:Literal>71</ogc:Literal>
							</ogc:PropertyIsEqualTo>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>merkLisati</ogc:PropertyName>
								<ogc:Literal>ohjeellinen</ogc:Literal>
							</ogc:PropertyIsEqualTo>
						</ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>	
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#f40a27</CssParameter>
							<CssParameter name="stroke-width">5.333333</CssParameter>
							<CssParameter name="stroke-dasharray">6.666667 3.333333</CssParameter>							
						</Stroke>
					</LineSymbolizer>
					</Rule>
					<Rule>
					<Title>Valtatie/kantatie, ohjeellinen label</Title>
					<ogc:Filter>
						<ogc:And>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
								<ogc:Literal>71</ogc:Literal>
							</ogc:PropertyIsEqualTo>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>merkLisati</ogc:PropertyName>
								<ogc:Literal>ohjeellinen</ogc:Literal>
							</ogc:PropertyIsEqualTo>
						</ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>200000</MaxScaleDenominator>	
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#f40a27</CssParameter>
						</Fill>
					</TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Seututie tai pääkatu</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>72</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>	
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#000000</CssParameter>
							<CssParameter name="stroke-width">4</CssParameter> 
						</Stroke>
					</LineSymbolizer>
					</Rule>
					<Rule>
					<Title>Seututie tai pääkatu label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>72</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>200000</MaxScaleDenominator>	
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#000000</CssParameter>
						</Fill>
					</TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Seututie tai pääkatu, parannettava</Title>
					<ogc:Filter>
						<ogc:And>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
								<ogc:Literal>72</ogc:Literal>
							</ogc:PropertyIsEqualTo>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>merkLisati</ogc:PropertyName>
								<ogc:Literal>parannettava</ogc:Literal>
							</ogc:PropertyIsEqualTo>
						</ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>	
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#f40a27</CssParameter>
							<CssParameter name="stroke-width">4</CssParameter> 
						</Stroke>
					</LineSymbolizer>
					</Rule>
					<Rule>
					<Title>Seututie tai pääkatu, parannettava label</Title>
					<ogc:Filter>
						<ogc:And>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
								<ogc:Literal>72</ogc:Literal>
							</ogc:PropertyIsEqualTo>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>merkLisati</ogc:PropertyName>
								<ogc:Literal>parannettava</ogc:Literal>
							</ogc:PropertyIsEqualTo>
						</ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>200000</MaxScaleDenominator>	
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#f40a27</CssParameter>
						</Fill>
					</TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Seututie tai pääkatu, ohjeellinen</Title>
					<ogc:Filter>
						<ogc:And>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
								<ogc:Literal>72</ogc:Literal>
							</ogc:PropertyIsEqualTo>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>merkLisati</ogc:PropertyName>
								<ogc:Literal>ohjeellinen</ogc:Literal>
							</ogc:PropertyIsEqualTo>
						</ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>	
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#f40a27</CssParameter>
							<CssParameter name="stroke-width">4</CssParameter> 
							<CssParameter name="stroke-dasharray">6.666667 3.333333</CssParameter>	
						</Stroke>
					</LineSymbolizer>
					</Rule>
					<Rule>
					<Title>Seututie tai pääkatu, ohjeellinen label</Title>
					<ogc:Filter>
						<ogc:And>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
								<ogc:Literal>72</ogc:Literal>
							</ogc:PropertyIsEqualTo>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>merkLisati</ogc:PropertyName>
								<ogc:Literal>ohjeellinen</ogc:Literal>
							</ogc:PropertyIsEqualTo>
						</ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>200000</MaxScaleDenominator>	
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#f40a27</CssParameter>
						</Fill>
					</TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Yhdystie</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>73</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>	
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#000000</CssParameter>
							<CssParameter name="stroke-width">2</CssParameter> 
						</Stroke>
					</LineSymbolizer>
					</Rule>
					<Rule>
					<Title>Yhdystie label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>73</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>200000</MaxScaleDenominator>	
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#000000</CssParameter>
						</Fill>
					</TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Yhdystie, parannettava</Title>
					<ogc:Filter>
						<ogc:And>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
								<ogc:Literal>73</ogc:Literal>
							</ogc:PropertyIsEqualTo>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>merkLisati</ogc:PropertyName>
								<ogc:Literal>parannettava</ogc:Literal>
							</ogc:PropertyIsEqualTo>
						</ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>	
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#f40a27</CssParameter>
							<CssParameter name="stroke-width">2</CssParameter> 
						</Stroke>
					</LineSymbolizer>
					</Rule>
					<Rule>
					<Title>Yhdystie, parannettava label</Title>
					<ogc:Filter>
						<ogc:And>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
								<ogc:Literal>73</ogc:Literal>
							</ogc:PropertyIsEqualTo>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>merkLisati</ogc:PropertyName>
								<ogc:Literal>parannettava</ogc:Literal>
							</ogc:PropertyIsEqualTo>
						</ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>200000</MaxScaleDenominator>	
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#f40a27</CssParameter>
						</Fill>
					</TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Yhdystie, ohjeellinen</Title>
					<ogc:Filter>
						<ogc:And>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
								<ogc:Literal>73</ogc:Literal>
							</ogc:PropertyIsEqualTo>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>merkLisati</ogc:PropertyName>
								<ogc:Literal>ohjeellinen</ogc:Literal>
							</ogc:PropertyIsEqualTo>
						</ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>	
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#f40a27</CssParameter>
							<CssParameter name="stroke-width">2</CssParameter> 
							<CssParameter name="stroke-dasharray">6.666667 3.333333</CssParameter>	
						</Stroke>
					</LineSymbolizer>
					</Rule>
					<Rule>
					<Title>Yhdystie, ohjeellinen label</Title>
					<ogc:Filter>
						<ogc:And>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
								<ogc:Literal>73</ogc:Literal>
							</ogc:PropertyIsEqualTo>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>merkLisati</ogc:PropertyName>
								<ogc:Literal>ohjeellinen</ogc:Literal>
							</ogc:PropertyIsEqualTo>
						</ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>200000</MaxScaleDenominator>	
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#f40a27</CssParameter>
						</Fill>
					</TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Muinaismuisto / historiallinen tie / kulttuuritie</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>108</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>	
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#a8dbd6</CssParameter>
							<CssParameter name="stroke-width">2</CssParameter> 
							<CssParameter name="stroke-dasharray">6.666667 3.333333</CssParameter>	
						</Stroke>
					</LineSymbolizer>
				</Rule>
				
				<Rule>
					<Title>Liikennetunneli</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>77</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>	
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#000000</CssParameter>
							<CssParameter name="stroke-width">9.333333</CssParameter> 
							<CssParameter name="stroke-dasharray">6.666667 3.333333</CssParameter>
						</Stroke>
					</LineSymbolizer>
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#ffffff</CssParameter>
							<CssParameter name="stroke-width">4</CssParameter>
							<CssParameter name="stroke-dasharray">6.666667 3.333333</CssParameter>
						</Stroke>
					</LineSymbolizer>
					<PointSymbolizer>
						<Geometry>
							<ogc:Function name="startPoint">
								<ogc:PropertyName>geom</ogc:PropertyName>
							</ogc:Function>
						</Geometry>
						<Graphic>
							<Mark>
								<WellKnownName>shape://oarrow</WellKnownName>
								<Fill>
									<CssParameter name="fill">#000000</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#000000</CssParameter>
									<CssParameter name="stroke-width">2</CssParameter>
								</Stroke>
							</Mark>
							<Size>30</Size>
							<Rotation> 
								<ogc:Function name="startAngle">
									<ogc:PropertyName>geom</ogc:PropertyName>
								</ogc:Function>
							</Rotation>
						</Graphic>
					</PointSymbolizer>
					<PointSymbolizer>
						<Geometry>
							<ogc:Function name="endPoint">
								<ogc:PropertyName>geom</ogc:PropertyName>
							</ogc:Function>
						</Geometry>
						<Graphic>
							<Mark>
								<WellKnownName>shape://oarrow</WellKnownName>
								<Fill>
									<CssParameter name="fill">#000000</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#000000</CssParameter>
									<CssParameter name="stroke-width">2</CssParameter>
								</Stroke>
							</Mark>
							<Size>30</Size>
							<Rotation>

								<ogc:Add> 
									<ogc:Function name="endAngle"> 
										<ogc:PropertyName>geom</ogc:PropertyName> 
									</ogc:Function> 
									<ogc:Literal>180.0</ogc:Literal> 
								</ogc:Add> 
							</Rotation>
						</Graphic>
					</PointSymbolizer>
				</Rule>
				
				<Rule>
					<Title>Liikennetunneli, kehitettävä</Title>
					<ogc:Filter>
						<ogc:And>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
								<ogc:Literal>77</ogc:Literal>
							</ogc:PropertyIsEqualTo>
							<ogc:PropertyIsLike wildCard="*" singleChar="#" escape="!">
								<ogc:PropertyName>merkLisati</ogc:PropertyName>
								<ogc:Literal>kehitett*</ogc:Literal>
							</ogc:PropertyIsLike>	
						</ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>	
					
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#f40a27</CssParameter>
							<CssParameter name="stroke-width">9.333333</CssParameter> 
							<CssParameter name="stroke-dasharray">6.666667 3.333333</CssParameter>
						</Stroke>
					</LineSymbolizer>
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#ffffff</CssParameter>
							<CssParameter name="stroke-width">4</CssParameter>
							<CssParameter name="stroke-dasharray">6.666667 3.333333</CssParameter>
						</Stroke>
					</LineSymbolizer>
					<PointSymbolizer>
						<Geometry>
							<ogc:Function name="startPoint">
								<ogc:PropertyName>geom</ogc:PropertyName>
							</ogc:Function>
						</Geometry>
						<Graphic>
							<Mark>
								<WellKnownName>shape://oarrow</WellKnownName>
								<Fill>
									<CssParameter name="fill">#f40a27</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#f40a27</CssParameter>
									<CssParameter name="stroke-width">2</CssParameter>
								</Stroke>
							</Mark>
							<Size>30</Size>
							<Rotation> 
								<ogc:Function name="startAngle">
									<ogc:PropertyName>geom</ogc:PropertyName>
								</ogc:Function>
							</Rotation>
						</Graphic>
					</PointSymbolizer>
					<PointSymbolizer>
						<Geometry>
							<ogc:Function name="endPoint">
								<ogc:PropertyName>geom</ogc:PropertyName>
							</ogc:Function>
						</Geometry>
						<Graphic>
							<Mark>
								<WellKnownName>shape://oarrow</WellKnownName>
								<Fill>
									<CssParameter name="fill">#f40a27</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#f40a27</CssParameter>
									<CssParameter name="stroke-width">2</CssParameter>
								</Stroke>
							</Mark>
							<Size>30</Size>
							<Rotation>
								<ogc:Add> 
									<ogc:Function name="endAngle"> 
										<ogc:PropertyName>geom</ogc:PropertyName> 
									</ogc:Function> 
									<ogc:Literal>180.0</ogc:Literal> 
								</ogc:Add> 
							</Rotation>
						</Graphic>
					</PointSymbolizer>
				</Rule>
				
				<Rule>
					<Title>Päärata</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>78</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>	
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#000000</CssParameter>
							<CssParameter name="stroke-width">2.666667</CssParameter> 
						</Stroke>
					</LineSymbolizer>
					<LineSymbolizer>
						<Stroke>
							<GraphicStroke>
								<Graphic>
									<Mark>
										<WellKnownName>shape://vertline</WellKnownName>
										<Stroke>
											<CssParameter name="stroke">#000000</CssParameter>
											<CssParameter name="stroke-width">0.666667</CssParameter>
										</Stroke>
									</Mark>
									<Size>6.666667</Size>
								</Graphic>
							</GraphicStroke>
						</Stroke>
					</LineSymbolizer>
				</Rule>
				
				<Rule>
					<Title>Liikennepaikka</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>781</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>	
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#000000</CssParameter>
							<CssParameter name="stroke-width">9.333333</CssParameter> 
						</Stroke>
					</LineSymbolizer>
				</Rule>
				
				<Rule>
					<Title>Päärata ja liikennepaikka, kehitettävä</Title>
					<ogc:Filter>
						<ogc:And>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
								<ogc:Literal>78</ogc:Literal>
							</ogc:PropertyIsEqualTo>
							<ogc:PropertyIsLike wildCard="*" singleChar="#" escape="!">
								<ogc:PropertyName>merkLisati</ogc:PropertyName>
								<ogc:Literal>kehitett*</ogc:Literal>
							</ogc:PropertyIsLike>
						</ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>	
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#f40a27</CssParameter>
							<CssParameter name="stroke-width">3.333333</CssParameter> 
						</Stroke>
					</LineSymbolizer>
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#000000</CssParameter>
							<CssParameter name="stroke-width">1.333333</CssParameter> 
						</Stroke>
					</LineSymbolizer>
					<LineSymbolizer>
						<Stroke>
							<GraphicStroke>
								<Graphic>
									<Mark>
										<WellKnownName>shape://vertline</WellKnownName>
										<Stroke>
											<CssParameter name="stroke">#000000</CssParameter>
											<CssParameter name="stroke-width">0.666667</CssParameter>
										</Stroke>
									</Mark>
									<Size>6.666667</Size>
								</Graphic>
							</GraphicStroke>
						</Stroke>
					</LineSymbolizer>
				</Rule>
				
				<Rule>
					<Title>Päärata ja liikennepaikka, uusi</Title>
					<ogc:Filter>
						<ogc:And>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
								<ogc:Literal>78</ogc:Literal>
							</ogc:PropertyIsEqualTo>
							<ogc:PropertyIsLike wildCard="*" singleChar="#" escape="!">
								<ogc:PropertyName>merkLisati</ogc:PropertyName>
								<ogc:Literal>Uusi</ogc:Literal>
							</ogc:PropertyIsLike>
						</ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>	
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#f40a27</CssParameter>
							<CssParameter name="stroke-width">2.666667</CssParameter> 
						</Stroke>
					</LineSymbolizer>
					<LineSymbolizer>
						<Stroke>
							<GraphicStroke>
								<Graphic>
									<Mark>
										<WellKnownName>shape://vertline</WellKnownName>
										<Stroke>
											<CssParameter name="stroke">#f40a27</CssParameter>
											<CssParameter name="stroke-width">0.666667</CssParameter>
										</Stroke>
									</Mark>
									<Size>6.666667</Size>
								</Graphic>
							</GraphicStroke>
						</Stroke>
					</LineSymbolizer>
				</Rule>

				<Rule>
					<Title>Yhdysrata/sivurata/kaupunkirata</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>79</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>	
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#000000</CssParameter>
							<CssParameter name="stroke-width">1.333333</CssParameter> 
						</Stroke>
					</LineSymbolizer>
					<LineSymbolizer>
						<Stroke>
							<GraphicStroke>
								<Graphic>
									<Mark>
										<WellKnownName>shape://vertline</WellKnownName>
										<Stroke>
											<CssParameter name="stroke">#000000</CssParameter>
											<CssParameter name="stroke-width">0.666667</CssParameter>
										</Stroke>
									</Mark>
									<Size>6.666667</Size>
								</Graphic>
							</GraphicStroke>
						</Stroke>
					</LineSymbolizer>
				</Rule>

				<Rule>
					<Title>Ulkoilureitti</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>80</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>	
					<LineSymbolizer>
						<Stroke>
							<GraphicStroke>
								<Graphic>
									<Mark>
										<WellKnownName>circle</WellKnownName>
										<Fill>
											<CssParameter name="fill">#54a81c</CssParameter>
										</Fill>
									</Mark>
									<Size>6</Size>
								</Graphic>
							</GraphicStroke>
							<CssParameter name="stroke-dasharray">5 5</CssParameter>
						</Stroke>
					</LineSymbolizer>
				</Rule>

				<Rule>
					<Title>Melontareitti tai vesiretkeilyreitti</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>109</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>	
					<LineSymbolizer>
						<Stroke>
							<GraphicStroke>
								<Graphic>
									<Mark>
										<WellKnownName>circle</WellKnownName>
										<Fill>
											<CssParameter name="fill">#003ebe</CssParameter>
										</Fill>
									</Mark>
									<Size>6</Size>
								</Graphic>
							</GraphicStroke>
							<CssParameter name="stroke-dasharray">5 5</CssParameter>
						</Stroke>
					</LineSymbolizer>
				</Rule>

				<Rule>
					<Title>Moottorikelkkailureitti</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>81</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>	
					<LineSymbolizer>
						<Stroke>
							<GraphicStroke>
								<Graphic>
									<Mark>
										<WellKnownName>circle</WellKnownName>
										<Fill>
											<CssParameter name="fill">#787878</CssParameter>
										</Fill>
									</Mark>
									<Size>6</Size>
								</Graphic>
							</GraphicStroke>
							<CssParameter name="stroke-dasharray">5 5</CssParameter>
						</Stroke>
					</LineSymbolizer>
				</Rule>

				<Rule>
					<Title>Laivaväylä</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>82</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>	
					<LineSymbolizer>
						<Stroke>
							<GraphicStroke>
								<Graphic>
									<Mark>
										<WellKnownName>circle</WellKnownName>
										<Fill>
											<CssParameter name="fill">#003ebe</CssParameter>
										</Fill>
									</Mark>
									<Size>6</Size>
								</Graphic>
							</GraphicStroke>
							<CssParameter name="stroke-dasharray">6.666667 8</CssParameter>
						</Stroke>
					</LineSymbolizer>
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#003ebe</CssParameter>
							<CssParameter name="stroke-width">2.666667</CssParameter> 
						</Stroke>
					</LineSymbolizer>
				</Rule>

				<Rule>
					<Title>Veneväylä</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>83</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>	
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#003ebe</CssParameter>
							<CssParameter name="stroke-width">2.666667</CssParameter> 
						</Stroke>
					</LineSymbolizer>
					<LineSymbolizer>
						<Stroke>
							<GraphicStroke>
								<Graphic>
									<Mark>
										<WellKnownName>circle</WellKnownName>
										<Fill>
											<CssParameter name="fill">#FFFFFF</CssParameter>
										</Fill>
										<Stroke>
											<CssParameter name="stroke">#003ebe</CssParameter>
											<CssParameter name="stroke-width">2</CssParameter> 
										</Stroke>
									</Mark>
									<Size>6</Size>
								</Graphic>
							</GraphicStroke>
							<CssParameter name="stroke-dasharray">6.666667 8</CssParameter>
						</Stroke>
					</LineSymbolizer>
				</Rule>

				<Rule>
					<Title>Pääjohto- tai linja</Title>
						<ogc:Filter>
							<ogc:And>
								<ogc:Or>
									<ogc:PropertyIsEqualTo>
										<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
										<ogc:Literal>84</ogc:Literal>
									</ogc:PropertyIsEqualTo>
									<ogc:PropertyIsEqualTo>
										<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
										<ogc:Literal>841</ogc:Literal>
									</ogc:PropertyIsEqualTo>
									<ogc:PropertyIsEqualTo>
										<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
										<ogc:Literal>842</ogc:Literal>
									</ogc:PropertyIsEqualTo>
									<ogc:PropertyIsEqualTo>
										<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
										<ogc:Literal>843</ogc:Literal>
									</ogc:PropertyIsEqualTo>
									<ogc:PropertyIsEqualTo>
										<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
										<ogc:Literal>844</ogc:Literal>
									</ogc:PropertyIsEqualTo>
								</ogc:Or>
								<ogc:And>
									<ogc:PropertyIsNotEqualTo>
										<ogc:PropertyName>merkLisati</ogc:PropertyName>
										<ogc:Literal>Uusi</ogc:Literal>
									</ogc:PropertyIsNotEqualTo>
									<ogc:PropertyIsNotEqualTo>
										<ogc:PropertyName>merkLisati</ogc:PropertyName>
										<ogc:Literal>Ohjeellinen</ogc:Literal>
									</ogc:PropertyIsNotEqualTo>
								</ogc:And>
							</ogc:And>
						</ogc:Filter>
						<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#000000</CssParameter>
							<CssParameter name="stroke-width">1.333333</CssParameter> 
						</Stroke>
					</LineSymbolizer>
					</Rule>
					<Rule>
					<Title>Pääjohto- tai linja label</Title>
						<ogc:Filter>
							<ogc:And>
								<ogc:Or>
									<ogc:PropertyIsEqualTo>
										<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
										<ogc:Literal>84</ogc:Literal>
									</ogc:PropertyIsEqualTo>
									<ogc:PropertyIsEqualTo>
										<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
										<ogc:Literal>841</ogc:Literal>
									</ogc:PropertyIsEqualTo>
									<ogc:PropertyIsEqualTo>
										<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
										<ogc:Literal>842</ogc:Literal>
									</ogc:PropertyIsEqualTo>
									<ogc:PropertyIsEqualTo>
										<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
										<ogc:Literal>843</ogc:Literal>
									</ogc:PropertyIsEqualTo>
									<ogc:PropertyIsEqualTo>
										<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
										<ogc:Literal>844</ogc:Literal>
									</ogc:PropertyIsEqualTo>
								</ogc:Or>
								<ogc:And>
									<ogc:PropertyIsNotEqualTo>
										<ogc:PropertyName>merkLisati</ogc:PropertyName>
										<ogc:Literal>Uusi</ogc:Literal>
									</ogc:PropertyIsNotEqualTo>
									<ogc:PropertyIsNotEqualTo>
										<ogc:PropertyName>merkLisati</ogc:PropertyName>
										<ogc:Literal>Ohjeellinen</ogc:Literal>
									</ogc:PropertyIsNotEqualTo>
								</ogc:And>
							</ogc:And>
						</ogc:Filter>
						<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>200000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">10</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#000000</CssParameter>
						</Fill>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#FFFFFF</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#000000</CssParameter>
									<CssParameter name="stroke-width">2</CssParameter> 
								</Stroke>
							</Mark>
							<Size>12</Size>
						</Graphic>
					</TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Pääjohto- tai linja, uusi</Title>
					<ogc:Filter>
						<ogc:And>
							<ogc:Or>
								<ogc:PropertyIsEqualTo>
									<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
									<ogc:Literal>84</ogc:Literal>
								</ogc:PropertyIsEqualTo>
								<ogc:PropertyIsEqualTo>
									<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
									<ogc:Literal>841</ogc:Literal>
								</ogc:PropertyIsEqualTo>
								<ogc:PropertyIsEqualTo>
									<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
									<ogc:Literal>842</ogc:Literal>
								</ogc:PropertyIsEqualTo>
								<ogc:PropertyIsEqualTo>
									<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
									<ogc:Literal>843</ogc:Literal>
								</ogc:PropertyIsEqualTo>
								<ogc:PropertyIsEqualTo>
									<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
									<ogc:Literal>844</ogc:Literal>
								</ogc:PropertyIsEqualTo>
							</ogc:Or>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>merkLisati</ogc:PropertyName>
								<ogc:Literal>Uusi</ogc:Literal>
							</ogc:PropertyIsEqualTo>
						</ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>	
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#f40a27</CssParameter>
							<CssParameter name="stroke-width">1.333333</CssParameter> 
						</Stroke>
					</LineSymbolizer>
					</Rule>
					<Rule>
					<Title>Pääjohto- tai linja, uusi label</Title>
					<ogc:Filter>
						<ogc:And>
							<ogc:Or>
								<ogc:PropertyIsEqualTo>
									<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
									<ogc:Literal>84</ogc:Literal>
								</ogc:PropertyIsEqualTo>
								<ogc:PropertyIsEqualTo>
									<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
									<ogc:Literal>841</ogc:Literal>
								</ogc:PropertyIsEqualTo>
								<ogc:PropertyIsEqualTo>
									<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
									<ogc:Literal>842</ogc:Literal>
								</ogc:PropertyIsEqualTo>
								<ogc:PropertyIsEqualTo>
									<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
									<ogc:Literal>843</ogc:Literal>
								</ogc:PropertyIsEqualTo>
								<ogc:PropertyIsEqualTo>
									<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
									<ogc:Literal>844</ogc:Literal>
								</ogc:PropertyIsEqualTo>
							</ogc:Or>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>merkLisati</ogc:PropertyName>
								<ogc:Literal>Uusi</ogc:Literal>
							</ogc:PropertyIsEqualTo>
						</ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>200000</MaxScaleDenominator>	
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">10</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#f40a27</CssParameter>
						</Fill>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#FFFFFF</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#f40a27</CssParameter>
									<CssParameter name="stroke-width">2</CssParameter> 
								</Stroke>
							</Mark>
							<Size>12</Size>
						</Graphic>
					</TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Pääjohto- tai linja, ohjeellinen</Title>
					<ogc:Filter>
						<ogc:And>
							<ogc:Or>
								<ogc:PropertyIsEqualTo>
									<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
									<ogc:Literal>84</ogc:Literal>
								</ogc:PropertyIsEqualTo>
								<ogc:PropertyIsEqualTo>
									<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
									<ogc:Literal>841</ogc:Literal>
								</ogc:PropertyIsEqualTo>
								<ogc:PropertyIsEqualTo>
									<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
									<ogc:Literal>842</ogc:Literal>
								</ogc:PropertyIsEqualTo>
								<ogc:PropertyIsEqualTo>
									<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
									<ogc:Literal>843</ogc:Literal>
								</ogc:PropertyIsEqualTo>
								<ogc:PropertyIsEqualTo>
									<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
									<ogc:Literal>844</ogc:Literal>
								</ogc:PropertyIsEqualTo>
							</ogc:Or>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>merkLisati</ogc:PropertyName>
								<ogc:Literal>Ohjeellinen</ogc:Literal>
							</ogc:PropertyIsEqualTo>
						</ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>	
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#f40a27</CssParameter>
							<CssParameter name="stroke-width">1.333333</CssParameter>
							<CssParameter name="stroke-dasharray">5.333333 2.666667</CssParameter>							
						</Stroke>
					</LineSymbolizer>
					</Rule>
					
					<Rule>
					<Title>Pääjohto- tai linja, ohjeellinen label</Title>
					<ogc:Filter>
						<ogc:And>
							<ogc:Or>
								<ogc:PropertyIsEqualTo>
									<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
									<ogc:Literal>84</ogc:Literal>
								</ogc:PropertyIsEqualTo>
								<ogc:PropertyIsEqualTo>
									<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
									<ogc:Literal>841</ogc:Literal>
								</ogc:PropertyIsEqualTo>
								<ogc:PropertyIsEqualTo>
									<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
									<ogc:Literal>842</ogc:Literal>
								</ogc:PropertyIsEqualTo>
								<ogc:PropertyIsEqualTo>
									<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
									<ogc:Literal>843</ogc:Literal>
								</ogc:PropertyIsEqualTo>
								<ogc:PropertyIsEqualTo>
									<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
									<ogc:Literal>844</ogc:Literal>
								</ogc:PropertyIsEqualTo>
							</ogc:Or>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>merkLisati</ogc:PropertyName>
								<ogc:Literal>Ohjeellinen</ogc:Literal>
							</ogc:PropertyIsEqualTo>
						</ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>200000</MaxScaleDenominator>	
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">10</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#f40a27</CssParameter>
						</Fill>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#FFFFFF</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#f40a27</CssParameter>
									<CssParameter name="stroke-width">2</CssParameter> 
								</Stroke>
							</Mark>
							<Size>12</Size>
						</Graphic>
					</TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Merkittävä rakennettu kulttuuriympäristö (maakunnallinen)</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>113</ogc:Literal>
						</ogc:PropertyIsEqualTo>                       
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>					
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#73b2ff</CssParameter>
							<CssParameter name="stroke-width">1</CssParameter> 
						</Stroke>
					</LineSymbolizer>					
				</Rule>
				
				<Rule>
					<Title>Merkittävä rakennettu kulttuuriympäristö (valtakunnallinen)</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>114</ogc:Literal>
						</ogc:PropertyIsEqualTo>                       
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>					
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#73b2ff</CssParameter>
							<CssParameter name="stroke-width">2</CssParameter> 
						</Stroke>
					</LineSymbolizer>					
				</Rule>				

				<!-- Muu-merkinnät -->

				<Rule>
					<Title>Muu kehittämisperiaatemerkintä, Liikenneväylän katkoviivamerkintä osoittaa vaihtoehtoisen ratkaisun tai ohjeellisen linjauksen (seututie)</Title>
					<ogc:Filter>
                      <ogc:And>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>202</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        <ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>ST</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        </ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>					
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#FF0000</CssParameter>
							<CssParameter name="stroke-width">1</CssParameter> 
						</Stroke>
					</LineSymbolizer>					
				</Rule>

				<Rule>
					<Title>Muu kehittämisperiaatemerkintä, Liikenneväylän katkoviivamerkintä osoittaa vaihtoehtoisen ratkaisun tai ohjeellisen linjauksen (seutuliikenteen rata)</Title>
					<ogc:Filter>
                      <ogc:And>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>202</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        <ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>SR</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        </ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>					
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#FF0000</CssParameter>
							<CssParameter name="stroke-width">1</CssParameter> 
						</Stroke>
					</LineSymbolizer>					
				</Rule>
				
				<Rule>
					<Title>Muu kehittämisperiaatemerkintä, Liikenneväylän katkoviivamerkintä osoittaa vaihtoehtoisen ratkaisun tai ohjeellisen linjauksen (seutuliikenteen rata)</Title>
					<ogc:Filter>
						<ogc:And>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>202</ogc:Literal>
						</ogc:PropertyIsEqualTo>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>PR-VA</ogc:Literal>
						</ogc:PropertyIsEqualTo>
						</ogc:And>
						</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#FF0000</CssParameter>
							<CssParameter name="stroke-width">1</CssParameter> 
						</Stroke>
					</LineSymbolizer>					
				</Rule>
						
				<Rule>
					<Title>Muu kehittämisperiaatemerkintä, Liikenneväylän katkoviivamerkintä osoittaa vaihtoehtoisen ratkaisun tai ohjeellisen linjauksen (seutuliikenteen rata)</Title>
					<ogc:Filter>
						<ogc:And>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>202</ogc:Literal>
						</ogc:PropertyIsEqualTo>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>PLR-VA</ogc:Literal>
						</ogc:PropertyIsEqualTo>
						</ogc:And>
						</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>						
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#FF0000</CssParameter>
							<CssParameter name="stroke-width">1</CssParameter> 
						</Stroke>
					</LineSymbolizer>					
				</Rule>
				
				<Rule>
					<Title>Muu kehittämisperiaatemerkintä, Pääradan vaihtoehtoisen ratkaisu tai ohjeellinen linjaus</Title>
					<ogc:Filter>
						<ogc:And>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>202</ogc:Literal>
						</ogc:PropertyIsEqualTo>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>PR</ogc:Literal>
						</ogc:PropertyIsEqualTo>
						</ogc:And>						
						</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>						
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#FF0000</CssParameter>
							<CssParameter name="stroke-width">1</CssParameter> 
						</Stroke>
					</LineSymbolizer>					
				</Rule>
				
				<Rule>
					<Title>Muu kehittämisperiaatemerkintä, Pääkaupunkiseudun poikittainen joukkoliikenteen yhteysväli</Title>
					<ogc:Filter>
                      <ogc:And>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>202</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        <ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>laatu</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        </ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>					
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#FF0000</CssParameter>
							<CssParameter name="stroke-width">1</CssParameter> 
						</Stroke>
					</LineSymbolizer>					
				</Rule>
				
				<Rule>
					<Title>Muu kehittämisperiaatemerkintä, Liikenneväylän katkoviivamerkintä osoittaa vaihtoehtoisen ratkaisun tai ohjeellisen linjauksen (laivaväylä)</Title>
					<ogc:Filter>
                      <ogc:And>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>202</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        <ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>lv</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        </ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>					
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#FF0000</CssParameter>
							<CssParameter name="stroke-width">1</CssParameter> 
						</Stroke>
					</LineSymbolizer>					
				</Rule>
				
				<Rule>
					<Title>Muu kehittämisperiaatemerkintä, Maakaasun runkoputken ohjeellinen linjaus</Title>
					<ogc:Filter>
                      <ogc:And>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>202</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        <ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>K</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        </ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>					
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#FF0000</CssParameter>
							<CssParameter name="stroke-width">1</CssParameter> 
						</Stroke>
					</LineSymbolizer>					
				</Rule>
				
				<Rule>
					<Title>Muu kehittämisperiaatemerkintä, Siirtoviemärin ohjeellinen linjaus</Title>
					<ogc:Filter>
                      <ogc:And>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>202</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        <ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>sv</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        </ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>					
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#FF0000</CssParameter>
							<CssParameter name="stroke-width">1</CssParameter> 
						</Stroke>
					</LineSymbolizer>					
				</Rule>
				
				<Rule>
					<Title>Muu kehittämisperiaatemerkintä, Kaukolämpöputken yhteystarve</Title>
					<ogc:Filter>
                      <ogc:And>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>202</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        <ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>L</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        </ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>					
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#FF0000</CssParameter>
							<CssParameter name="stroke-width">1</CssParameter> 
						</Stroke>
					</LineSymbolizer>					
				</Rule>
				
				<Rule>
					<Title>Muu kehittämisperiaatemerkintä, Siirtoviemärin ohjeellinen linjaus</Title>
					<ogc:Filter>
                      <ogc:And>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>202</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        <ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>sv1</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        </ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>					
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#FF0000</CssParameter>
							<CssParameter name="stroke-width">1</CssParameter> 
						</Stroke>
					</LineSymbolizer>					
				</Rule>
				
				<Rule>
					<Title>Muu kehittämisperiaatemerkintä, Kehäkaupungin kehittämisvyöhyke</Title>
					<ogc:Filter>
                      <ogc:And>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>202</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        <ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>kk</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        </ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>					
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#FF0000</CssParameter>
							<CssParameter name="stroke-width">1</CssParameter> 
						</Stroke>
					</LineSymbolizer>					
				</Rule>
				
				<Rule>
					<Title>Muu kehittämisperiaatemerkintä, Tieliikenteen yhteystarve</Title>
					<ogc:Filter>
                      <ogc:And>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>202</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        <ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>ty</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        </ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>					
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#FF0000</CssParameter>
							<CssParameter name="stroke-width">1</CssParameter> 
						</Stroke>
					</LineSymbolizer>					
				</Rule>
              
				<Rule>
					<Title>Muu kehittämisperiaatemerkintä</Title>
					<ogc:Filter>
                      <ogc:And>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>202</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        <ogc:PropertyIsNotEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>ST</ogc:Literal>
						</ogc:PropertyIsNotEqualTo>
                        <ogc:PropertyIsNotEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>SR</ogc:Literal>
						</ogc:PropertyIsNotEqualTo>
                        <ogc:PropertyIsNotEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>PR-VA</ogc:Literal>
						</ogc:PropertyIsNotEqualTo>
                        <ogc:PropertyIsNotEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>PLR-VA</ogc:Literal>
						</ogc:PropertyIsNotEqualTo>
                        <ogc:PropertyIsNotEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>PR</ogc:Literal>
						</ogc:PropertyIsNotEqualTo>
                        <ogc:PropertyIsNotEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>laatu</ogc:Literal>
						</ogc:PropertyIsNotEqualTo>
                        <ogc:PropertyIsNotEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>lv</ogc:Literal>
						</ogc:PropertyIsNotEqualTo>
                        <ogc:PropertyIsNotEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>K</ogc:Literal>
						</ogc:PropertyIsNotEqualTo>
                        <ogc:PropertyIsNotEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>sv</ogc:Literal>
						</ogc:PropertyIsNotEqualTo>
                        <ogc:PropertyIsNotEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>L</ogc:Literal>
						</ogc:PropertyIsNotEqualTo>
                        <ogc:PropertyIsNotEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>sv1</ogc:Literal>
						</ogc:PropertyIsNotEqualTo>
                        <ogc:PropertyIsNotEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>kk</ogc:Literal>
						</ogc:PropertyIsNotEqualTo>
                        <ogc:PropertyIsNotEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>ty</ogc:Literal>
						</ogc:PropertyIsNotEqualTo>
                        </ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>					
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#000000</CssParameter>
							<CssParameter name="stroke-width">1</CssParameter> 
						</Stroke>
					</LineSymbolizer>					
				</Rule>
				
				<Rule>
					<Title>Muu osa-aluemerkintä</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>204</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>					
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#000000</CssParameter>
							<CssParameter name="stroke-width">1</CssParameter> 
						</Stroke>
					</LineSymbolizer>					
				</Rule>
				
				<Rule>
					<Title>Muu viivamerkintä, Maisematie</Title>
					<ogc:Filter>
                      <ogc:And>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>205</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        <ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>pt</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        </ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>					
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#FF0000</CssParameter>
							<CssParameter name="stroke-width">1</CssParameter> 
						</Stroke>
					</LineSymbolizer>					
				</Rule>
				
				<Rule>
					<Title>Muu viivamerkintä, Kulttuuriympäristön tai maiseman vaalimisen kannalta tärkeä alue, tie tai kohde</Title>
					<ogc:Filter>
                      <ogc:And>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>205</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        <ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>ma</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        </ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>					
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#FF0000</CssParameter>
							<CssParameter name="stroke-width">1</CssParameter> 
						</Stroke>
					</LineSymbolizer>					
				</Rule>
				
				<Rule>
					<Title>Muu viivamerkintä, Valtakunnallisesti merkittävä rakennettu kulttuuriympäristö (RKY 2009)</Title>
					<ogc:Filter>
                      <ogc:And>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>205</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        <ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>ma/vm</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        </ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>					
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#FF0000</CssParameter>
							<CssParameter name="stroke-width">1</CssParameter> 
						</Stroke>
					</LineSymbolizer>					
				</Rule>
				
				<Rule>
					<Title>Muu viivamerkintä, jätevesitunneli</Title>
					<ogc:Filter>
                      <ogc:And>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>205</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        <ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>j</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        </ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>					
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#FF0000</CssParameter>
							<CssParameter name="stroke-width">1</CssParameter> 
						</Stroke>
					</LineSymbolizer>					
				</Rule>
				
				<Rule>
					<Title>Muu viivamerkintä, Vedenhankinnan kannalta arvokas pintavesialue</Title>
					<ogc:Filter>
                      <ogc:And>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>205</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        <ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>av</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        </ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>					
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#FF0000</CssParameter>
							<CssParameter name="stroke-width">1</CssParameter> 
						</Stroke>
					</LineSymbolizer>					
				</Rule>
				
				<Rule>
					<Title>Muu viivamerkintä, Liikenneväylän katkoviivamerkintä osoittaa vaihtoehtoisen ratkaisun tai ohjeellisen linjauksen (seututie)</Title>
					<ogc:Filter>
                      <ogc:And>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>205</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        <ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>jy</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        </ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>					
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#FF0000</CssParameter>
							<CssParameter name="stroke-width">1</CssParameter> 
						</Stroke>
					</LineSymbolizer>					
				</Rule>

				<Rule>
					<Title>Muu viivamerkintä</Title>
					<ogc:Filter>
                      <ogc:And>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>205</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        <ogc:PropertyIsNotEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>pt</ogc:Literal>
						</ogc:PropertyIsNotEqualTo>
                        <ogc:PropertyIsNotEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>ma</ogc:Literal>
						</ogc:PropertyIsNotEqualTo>
                        <ogc:PropertyIsNotEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>ma/vm</ogc:Literal>
						</ogc:PropertyIsNotEqualTo>
                        <ogc:PropertyIsNotEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>j</ogc:Literal>
						</ogc:PropertyIsNotEqualTo>
                        <ogc:PropertyIsNotEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>av</ogc:Literal>
						</ogc:PropertyIsNotEqualTo>
                        <ogc:PropertyIsNotEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>jy</ogc:Literal>
						</ogc:PropertyIsNotEqualTo>
                        </ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>					
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#000000</CssParameter>
							<CssParameter name="stroke-width">1</CssParameter> 
						</Stroke>
					</LineSymbolizer>					
				</Rule>
				
				
			<!--- Kehittämisvyöhykkeet --->
			
			
				<Rule>
					<Title>Ekologinen kehittämisvyöhyke</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>300</ogc:Literal>
						</ogc:PropertyIsEqualTo>                       
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>					
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#54A81C</CssParameter>
							<CssParameter name="stroke-width">7</CssParameter> 
						</Stroke>
					</LineSymbolizer>					
				</Rule>

				<Rule>
					<Title>Kaupan/ palveluiden kehittämisvyöhyke</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>301</ogc:Literal>
						</ogc:PropertyIsEqualTo>                       
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>					
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#ED9E4F</CssParameter>
							<CssParameter name="stroke-width">7</CssParameter> 
						</Stroke>
					</LineSymbolizer>					
				</Rule>
				
				<Rule>
					<Title>Taajamatoimintojen kehittämisvyöhyke</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>302</ogc:Literal>
						</ogc:PropertyIsEqualTo>                       
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>					
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#DFBF8F</CssParameter>
							<CssParameter name="stroke-width">7</CssParameter> 
						</Stroke>
					</LineSymbolizer>					
				</Rule>
				
				<Rule>
					<Title>Keskustatoimintojen kehittämisvyöhyke</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>304</ogc:Literal>
						</ogc:PropertyIsEqualTo>                       
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>					
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#CC0A2E</CssParameter>
							<CssParameter name="stroke-width">7</CssParameter> 
						</Stroke>
					</LineSymbolizer>					
				</Rule>
				
				<Rule>
					<Title>Teollisuuden ja logistiikan kehittämisvyöhyke</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>305</ogc:Literal>
						</ogc:PropertyIsEqualTo>                       
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>					
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#8F808F</CssParameter>
							<CssParameter name="stroke-width">7</CssParameter> 
						</Stroke>
					</LineSymbolizer>					
				</Rule>
				
				<Rule>
					<Title>Energianhuollon / energiantuotannon kehittämisvyöhyke</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>306</ogc:Literal>
						</ogc:PropertyIsEqualTo>                       
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>					
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#FF73DF</CssParameter>
							<CssParameter name="stroke-width">7</CssParameter> 
						</Stroke>
					</LineSymbolizer>					
				</Rule>

				<Rule>
					<Title>Tärkeä vedenhankintaan soveltuva pintavesialue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>307</ogc:Literal>
						</ogc:PropertyIsEqualTo>                       
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>  <MaxScaleDenominator>500000</MaxScaleDenominator>					
					<LineSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#4281b9</CssParameter>
							<CssParameter name="stroke-width">2.666667</CssParameter>
							<CssParameter name="stroke-dasharray">5.333333 2.666667 1.333333 2.666667</CssParameter>
						</Stroke>
					</LineSymbolizer>					
				</Rule>

				
			</FeatureTypeStyle>
		</UserStyle>
	</NamedLayer>
</StyledLayerDescriptor>
