﻿<?xml version="1.0" encoding="UTF-8"?>
<StyledLayerDescriptor 
  version="1.0.0"
  xsi:schemaLocation="http://www.opengis.net/sld http://schemas.opengis.net/sld/1.0.0/StyledLayerDescriptor.xsd"
  xmlns="http://www.opengis.net/sld" 
  xmlns:ogc="http://www.opengis.net/ogc"
  xmlns:xlink="http://www.w3.org/1999/xlink" 
  xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">

	<NamedLayer>
		<Name>hame_pisteet</Name>
		<UserStyle>
			<Name>hame_pisteet</Name>
			<Title>Pistemmäiset merkinnät ja niiden labelit</Title>
			<FeatureTypeStyle>

				<!-- Kehittämisperiaatemerkinnät -->

				<Rule>
					<Title>Arvokas maisema-alue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>11</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#a8dbd8</CssParameter>
								</Fill>
							</Mark>
							<Size>12</Size>
						</Graphic>
					</PointSymbolizer>
				</Rule>

				<Rule>
					<Title>Arvokas harjualue tai muu geologinen muodostuma</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>8</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>200000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#000000</CssParameter>
								</Fill>
							</Mark>
							<Size>12</Size>
						</Graphic>
					</PointSymbolizer>
					</Rule>
					<Rule>
					<Title>Arvokas harjualue tai muu geologinen muodostuma label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>8</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>90000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">10</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.0</AnchorPointX>
									<AnchorPointY>0.0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>4</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#000000</CssParameter>
						</Fill>
					<VendorOption name="partials">true</VendorOption></TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Natura 2000-verkostoon kuuluva tai ehdotettu alue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>14</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>square</WellKnownName>
								<Fill>
									<CssParameter name="fill">#9c9c9c</CssParameter>
								</Fill>
							</Mark>
							<Size>10</Size>
						</Graphic>
					</PointSymbolizer>
				</Rule>	
			<!-- Kehittämisperiaatemerkinnät -->		
				<Rule>
					<Title>Ekologisen kehittämisen kohdealue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>300</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#54A81C</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#000000</CssParameter>
									<CssParameter name="stroke-width">0.5</CssParameter>
								</Stroke>
							</Mark>
							<Size>10</Size>
						</Graphic>
					</PointSymbolizer>
				</Rule>	
				
				<Rule>
					<Title>Kaupan/ palveluiden kehittämisen kohdealue</Title>
					<ogc:Filter>                     
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>301</ogc:Literal>
						</ogc:PropertyIsEqualTo>                        
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>				
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#ed9e4f</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#000000</CssParameter>
									<CssParameter name="stroke-width">0.5</CssParameter>
								</Stroke>
							</Mark>
							<Size>10</Size>
						</Graphic>
					</PointSymbolizer>					
				</Rule>
				
				<Rule>
					<Title>Taajamatoimintojen kehittämisvyöhyke</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>302</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#DFBF8F</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#000000</CssParameter>
									<CssParameter name="stroke-width">0.5</CssParameter>
								</Stroke>
							</Mark>
							<Size>10</Size>
						</Graphic>
					</PointSymbolizer>
				</Rule>	
				
				<Rule>
					<Title>Liikenteen kehittämisen kohdealue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>303</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#9b4f00</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#000000</CssParameter>
									<CssParameter name="stroke-width">0.5</CssParameter>
								</Stroke>
							</Mark>
							<Size>10</Size>
						</Graphic>
					</PointSymbolizer>
				</Rule>	
				
				<Rule>
					<Title>Keskustatoimintojen kehittämisvyöhyke</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>304</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#cc0a2e</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#000000</CssParameter>
									<CssParameter name="stroke-width">0.5</CssParameter>
								</Stroke>
							</Mark>
							<Size>10</Size>
						</Graphic>
					</PointSymbolizer>				
				</Rule>	
				
				<Rule>
					<Title>Teollisuuden ja logistiikan kehittämisen kohdealue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>305</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#8f808f</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#000000</CssParameter>
									<CssParameter name="stroke-width">0.5</CssParameter>
								</Stroke>
							</Mark>
							<Size>10</Size>
						</Graphic>
					</PointSymbolizer>
				
				</Rule>	
				
				<Rule>
					<Title>Energiahuollon/ energiantuotannon kehittämisen kohdealue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>306</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#ff73df</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#000000</CssParameter>
									<CssParameter name="stroke-width">0.5</CssParameter>
								</Stroke>
							</Mark>
							<Size>10</Size>
						</Graphic>
					</PointSymbolizer>				
				</Rule>	

				<Rule>
					<Title>Luonnon monimuotoisuuden kannalta erityisen tärkeä alue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>15</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#54a81c</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#000000</CssParameter>
									<CssParameter name="stroke-width">1.333333</CssParameter>
								</Stroke>
							</Mark>
							<Size>12</Size>
						</Graphic>
					</PointSymbolizer>
					</Rule>
					<Rule>
					<Title>Luonnon monimuotoisuuden kannalta erityisen tärkeä alue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>15</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>90000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">10</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.0</AnchorPointX>
									<AnchorPointY>0.0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>4</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#000000</CssParameter>
						</Fill>
					<VendorOption name="partials">true</VendorOption></TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Unescon maailmanperintökohde</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>16</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#000000</CssParameter>
								</Fill>
							</Mark>
							<Size>12</Size>
						</Graphic>
					</PointSymbolizer>
					</Rule>
					<Rule>
					<Title>Unescon maailmanperintökohde label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>16</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>200000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>un</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">10</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.0</AnchorPointX>
									<AnchorPointY>0.0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>4</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#000000</CssParameter>
						</Fill>
					<VendorOption name="partials">true</VendorOption></TextSymbolizer>
				</Rule>
				<Rule>
					<Title>Kansallinen kaupunkipuisto</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>17</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#ffffff</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#006d00</CssParameter>
									<CssParameter name="stroke-width">3</CssParameter>
								</Stroke>
							</Mark>
							<Size>12</Size>
						</Graphic>
					</PointSymbolizer>
					</Rule>
					<Rule>
					<Title>Kansallinen kaupunkipuisto label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>17</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>90000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>kp</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">10</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.0</AnchorPointX>
									<AnchorPointY>0.0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>4</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#000000</CssParameter>
                      </Fill>
					<VendorOption name="partials">true</VendorOption></TextSymbolizer>
				</Rule>
				
				<Rule>
					<Title>Melualue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>18</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#ffffff</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#000000</CssParameter>
									<CssParameter name="stroke-width">3</CssParameter>
								</Stroke>
							</Mark>
							<Size>12</Size>
						</Graphic>
					</PointSymbolizer>
					</Rule>
					<Rule>
					<Title>Melualue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>18</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>90000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>me</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">10</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.0</AnchorPointX>
									<AnchorPointY>0.0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>4</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#000000</CssParameter>
                      </Fill>
					<VendorOption name="partials">true</VendorOption></TextSymbolizer>
				</Rule>
				
				<Rule>
					<Title>Vaara-alue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>19</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#ffffff</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#6e6e6e</CssParameter>
									<CssParameter name="stroke-width">3</CssParameter>
								</Stroke>
							</Mark>
							<Size>12</Size>
						</Graphic>
					</PointSymbolizer>
					</Rule>
					<Rule>
					<Title>Vaara-alue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>19</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>90000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>va</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">10</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.0</AnchorPointX>
									<AnchorPointY>0.0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>4</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#000000</CssParameter>
                      </Fill>
					<VendorOption name="partials">true</VendorOption></TextSymbolizer>
				</Rule>
				
				<Rule>
					<Title>Suojavyöhyke</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>20</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#ffffff</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#6e6e6e</CssParameter>
									<CssParameter name="stroke-width">3</CssParameter>
								</Stroke>
							</Mark>
							<Size>12</Size>
						</Graphic>
					</PointSymbolizer>
					</Rule>
					<Rule>
					<Title>Suojavyöhyke label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>20</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>90000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>sv</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">10</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.0</AnchorPointX>
									<AnchorPointY>0.0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>4</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#000000</CssParameter>
                      </Fill>
					<VendorOption name="partials">true</VendorOption></TextSymbolizer>
				</Rule>
				<Rule>
					<Title>Loma- ja matkailualue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>32</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#ffd12b</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#000000</CssParameter>
									<CssParameter name="stroke-width">1.333333</CssParameter>
								</Stroke>
							</Mark>
							<Size>12</Size>
						</Graphic>
					</PointSymbolizer>
					</Rule>
					<Rule>
					<Title>Loma- ja matkailualue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>32</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>90000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">10</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.0</AnchorPointX>
									<AnchorPointY>0.0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>4</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#000000</CssParameter>
                      </Fill>
					<VendorOption name="partials">true</VendorOption></TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Loma-asuntoalue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>33</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#ffd12b</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#000000</CssParameter>
									<CssParameter name="stroke-width">1.333333</CssParameter>
								</Stroke>
							</Mark>
							<Size>12</Size>
						</Graphic>
					</PointSymbolizer>
					</Rule>
					<Rule>
					<Title>Loma-asuntoalue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>33</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>90000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">10</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.0</AnchorPointX>
									<AnchorPointY>0.0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>4</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#000000</CssParameter>
                      </Fill>
					<VendorOption name="partials">true</VendorOption></TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Matkailupalvelujen alue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>34</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#ffd12b</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#000000</CssParameter>
									<CssParameter name="stroke-width">1.333333</CssParameter>
								</Stroke>
							</Mark>
							<Size>12</Size>
						</Graphic>
					</PointSymbolizer>
					</Rule>
					<Rule>
					<Title>Matkailupalvelujen alue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>34</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>90000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">10</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.0</AnchorPointX>
									<AnchorPointY>0.0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>4</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#000000</CssParameter>
                      </Fill>
					<VendorOption name="partials">true</VendorOption></TextSymbolizer>
				</Rule>

				<!-- Kohde- ja viivamerkinnät -->
				<Rule>
					<Title>Maaliikenteen alue, kohdemerkintä</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>36</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#ffffff</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#ff0000</CssParameter>
									<CssParameter name="stroke-width">3</CssParameter>
								</Stroke>
							</Mark>
							<Size>12</Size>
						</Graphic>
					</PointSymbolizer>
					</Rule>
					<Rule>
					<Title>Maaliikenteen alue, kohdemerkinä label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>36</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>90000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">10</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.0</AnchorPointX>
									<AnchorPointY>0.0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>4</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#000000</CssParameter>
                      </Fill>
					<VendorOption name="partials">true</VendorOption></TextSymbolizer>
				</Rule>	

				<Rule>
					<Title>Keskustatoimintojen alue, kohdemerkintä</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>55</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#cc0a2e</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#000000</CssParameter>
									<CssParameter name="stroke-width">1.333333</CssParameter>
								</Stroke>
							</Mark>
							<Size>14</Size>
						</Graphic>
					</PointSymbolizer>
					</Rule>
					<Rule>
					<Title>Keskustatoimintojen alue, kohdemerkinä label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>55</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>90000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">10</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.0</AnchorPointX>
									<AnchorPointY>0.0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>4</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#000000</CssParameter>
                      </Fill>
					<VendorOption name="partials">true</VendorOption></TextSymbolizer>
				</Rule>	
				
				<Rule>
					<Title>Keskustatoimintojen alakeskus</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>56</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#cc0a2e</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#000000</CssParameter>
									<CssParameter name="stroke-width">1.333333</CssParameter>
								</Stroke>
							</Mark>
							<Size>14</Size>
						</Graphic>
					</PointSymbolizer>
					</Rule>
					<Rule>
					<Title>Keskustatoimintojen alakeskus label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>56</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>90000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">10</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.0</AnchorPointX>
									<AnchorPointY>0.0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>4</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#000000</CssParameter>
                      </Fill>
					<VendorOption name="partials">true</VendorOption></TextSymbolizer>
				</Rule>	

				<Rule>
					<Title>Vähittäiskaupan suuryksikkö</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>57</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#ed9e4f</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#000000</CssParameter>
									<CssParameter name="stroke-width">1.333333</CssParameter>
								</Stroke>
							</Mark>
							<Size>14</Size>
						</Graphic>
					</PointSymbolizer>
					</Rule>
					<Rule>
					<Title>Vähittäiskaupan suuryksikkö label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>57</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>90000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">10</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.0</AnchorPointX>
									<AnchorPointY>0.0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>4</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#000000</CssParameter>
                      </Fill>
					<VendorOption name="partials">true</VendorOption></TextSymbolizer>
				</Rule>	

				<Rule>
					<Title>Taajamatoimintojen alue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>95</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#dfbf8f</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#000000</CssParameter>
									<CssParameter name="stroke-width">1.333333</CssParameter>
								</Stroke>
							</Mark>
							<Size>14</Size>
						</Graphic>
					</PointSymbolizer>
					</Rule>
					<Rule>
					<Title>Taajamatoimintojen alue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>95</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>90000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">10</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.0</AnchorPointX>
									<AnchorPointY>0.0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>4</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#000000</CssParameter>
                      </Fill>
					<VendorOption name="partials">true</VendorOption></TextSymbolizer>
				</Rule>	

				<Rule>
					<Title>Kylä</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>58</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#dfbf8f</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#000000</CssParameter>
									<CssParameter name="stroke-width">1.333333</CssParameter>
								</Stroke>
							</Mark>
							<Size>14</Size>
						</Graphic>
					</PointSymbolizer>
					</Rule>
					<Rule>
					<Title>Kylä label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>58</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>90000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">10</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.0</AnchorPointX>
									<AnchorPointY>0.0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>4</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#000000</CssParameter>
						</Fill>
					<VendorOption name="partials">true</VendorOption></TextSymbolizer>
				</Rule>	

				<Rule>
					<Title>Palvelujen alue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>59</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#ed9e4f</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#000000</CssParameter>
									<CssParameter name="stroke-width">1.333333</CssParameter>
								</Stroke>
							</Mark>
							<Size>14</Size>
						</Graphic>
					</PointSymbolizer>
					</Rule>
					<Rule>
					<Title>Palvelujen alue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>59</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>90000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">10</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.0</AnchorPointX>
									<AnchorPointY>0.0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>4</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#000000</CssParameter>
						</Fill>
					<VendorOption name="partials">true</VendorOption></TextSymbolizer>
				</Rule>	

				<Rule>
					<Title>Työpaikka-alue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>96</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#fa738c</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#000000</CssParameter>
									<CssParameter name="stroke-width">1.333333</CssParameter>
								</Stroke>
							</Mark>
							<Size>14</Size>
						</Graphic>
					</PointSymbolizer>
					</Rule>
					<Rule>
					<Title>Työpaikka-alue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>96</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>90000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">10</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.0</AnchorPointX>
									<AnchorPointY>0.0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>4</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#000000</CssParameter>
						</Fill>
					<VendorOption name="partials">true</VendorOption></TextSymbolizer>
				</Rule>	

				<Rule>
					<Title>Teollisuus- ja varastoalue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>60</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#bababa</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#000000</CssParameter>
									<CssParameter name="stroke-width">1.333333</CssParameter>
								</Stroke>
							</Mark>
							<Size>14</Size>
						</Graphic>
					</PointSymbolizer>
					</Rule>
					<Rule>
					<Title>Teollisuus- ja varastoalue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>60</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>90000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">10</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.0</AnchorPointX>
									<AnchorPointY>0.0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>4</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#000000</CssParameter>
						</Fill>
					<VendorOption name="partials">true</VendorOption></TextSymbolizer>
				</Rule>	

				<Rule>
					<Title>Teollisuus- ja varastoalue, jolla on/jolle saa sijoittaa merkittävän, vaarallisia kemikaaleja valmistavan tai varastoivan laitoksen</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>61</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#bababa</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#000000</CssParameter>
									<CssParameter name="stroke-width">1.333333</CssParameter>
								</Stroke>
							</Mark>
							<Size>14</Size>
						</Graphic>
					</PointSymbolizer>
					</Rule>
					<Rule>
					<Title>Teollisuus- ja varastoalue, jolla on/jolle saa sijoittaa merkittävän, vaarallisia kemikaaleja valmistavan tai varastoivan laitoksen label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>61</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>90000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">10</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.0</AnchorPointX>
									<AnchorPointY>0.0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>4</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#000000</CssParameter>
						</Fill>
					<VendorOption name="partials">true</VendorOption></TextSymbolizer>
				</Rule>	

				<Rule>
					<Title>Erityisalue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>39</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#ffbee8</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#000000</CssParameter>
									<CssParameter name="stroke-width">1.333333</CssParameter>
								</Stroke>
							</Mark>
							<Size>12</Size>
						</Graphic>
					</PointSymbolizer>
					</Rule>
					<Rule>
					<Title>Erityisalue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>39</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>90000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">10</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.0</AnchorPointX>
									<AnchorPointY>0.0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>4</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#000000</CssParameter>
						</Fill>
					<VendorOption name="partials">true</VendorOption></TextSymbolizer>
				</Rule>	

				<Rule>
					<Title>Energiahuollon alue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>41</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#ffbee8</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#000000</CssParameter>
									<CssParameter name="stroke-width">1.333333</CssParameter>
								</Stroke>
							</Mark>
							<Size>12</Size>
						</Graphic>
					</PointSymbolizer>
					</Rule>
					<Rule>
					<Title>Energiahuollon alue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>41</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>90000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">10</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.0</AnchorPointX>
									<AnchorPointY>0.0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>4</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#000000</CssParameter>
						</Fill>
					<VendorOption name="partials">true</VendorOption></TextSymbolizer>
				</Rule>	

				<Rule>
					<Title>Yhdyskuntateknisen huollon alue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>40</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#ffbee8</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#000000</CssParameter>
									<CssParameter name="stroke-width">1.333333</CssParameter>
								</Stroke>
							</Mark>
							<Size>12</Size>
						</Graphic>
					</PointSymbolizer>
					</Rule>
					<Rule>
					<Title>Yhdyskuntateknisen huollon alue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>40</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>90000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">10</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.0</AnchorPointX>
									<AnchorPointY>0.0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>4</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#000000</CssParameter>
						</Fill>
					<VendorOption name="partials">true</VendorOption></TextSymbolizer>
				</Rule>	

				<Rule>
					<Title>Jätteenkäsittelyalue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>42</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#ffbee8</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#000000</CssParameter>
									<CssParameter name="stroke-width">1.333333</CssParameter>
								</Stroke>
							</Mark>
							<Size>12</Size>
						</Graphic>
					</PointSymbolizer>
					</Rule>
					<Rule>
					<Title>Jätteenkäsittelyalue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>42</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>90000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">10</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.0</AnchorPointX>
									<AnchorPointY>0.0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>4</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#000000</CssParameter>
						</Fill>
					<VendorOption name="partials">true</VendorOption></TextSymbolizer>
				</Rule>	

				<Rule>
					<Title>Maa-ainesten ottoalue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>43</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#ffbee8</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#000000</CssParameter>
									<CssParameter name="stroke-width">1.333333</CssParameter>
								</Stroke>
							</Mark>
							<Size>12</Size>
						</Graphic>
					</PointSymbolizer>
					</Rule>
					<Rule>
					<Title>Maa-ainesten ottoalue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>43</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>90000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">10</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.0</AnchorPointX>
									<AnchorPointY>0.0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>4</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#000000</CssParameter>
						</Fill>
					<VendorOption name="partials">true</VendorOption></TextSymbolizer>
				</Rule>	

				<Rule>
					<Title>Kaivosalue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>44</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#ffbee8</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#000000</CssParameter>
									<CssParameter name="stroke-width">1.333333</CssParameter>
								</Stroke>
							</Mark>
							<Size>12</Size>
						</Graphic>
					</PointSymbolizer>
					</Rule>
					<Rule>
					<Title>Kaivosalue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>44</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>90000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">10</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.0</AnchorPointX>
									<AnchorPointY>0.0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>4</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#000000</CssParameter>
						</Fill>
					<VendorOption name="partials">true</VendorOption></TextSymbolizer>
				</Rule>	

				<Rule>
					<Title>Puolustusvoimien alue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>45</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#ffbee8</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#000000</CssParameter>
									<CssParameter name="stroke-width">1.333333</CssParameter>
								</Stroke>
							</Mark>
							<Size>12</Size>
						</Graphic>
					</PointSymbolizer>
					</Rule>
					<Rule>
					<Title>Puolustusvoimien alue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>45</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>90000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">10</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.0</AnchorPointX>
									<AnchorPointY>0.0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>4</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#000000</CssParameter>
						</Fill>
					<VendorOption name="partials">true</VendorOption></TextSymbolizer>
				</Rule>	

				<Rule>
					<Title>Puolustusvoimien ampuma- ja harjoitusalue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>89</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#ffbee8</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#000000</CssParameter>
									<CssParameter name="stroke-width">1.333333</CssParameter>
								</Stroke>
							</Mark>
							<Size>12</Size>
						</Graphic>
					</PointSymbolizer>
					</Rule>
					<Rule>
					<Title>Puolustusvoimien ampuma- ja harjoitusalue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>89</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>90000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">10</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.0</AnchorPointX>
									<AnchorPointY>0.0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>4</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#000000</CssParameter>
						</Fill>
					<VendorOption name="partials">true</VendorOption></TextSymbolizer>
				</Rule>	

				<Rule>
					<Title>Ampumarata</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>105</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#ffbee8</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#000000</CssParameter>
									<CssParameter name="stroke-width">1.333333</CssParameter>
								</Stroke>
							</Mark>
							<Size>12</Size>
						</Graphic>
					</PointSymbolizer>
					</Rule>
					<Rule>
					<Title>Ampumarata label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>105</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>90000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">10</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.0</AnchorPointX>
									<AnchorPointY>0.0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>4</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#000000</CssParameter>
						</Fill>
					<VendorOption name="partials">true</VendorOption></TextSymbolizer>
				</Rule>	

				<Rule>
					<Title>Suojelukohde</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>62</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>square</WellKnownName>
								<Fill>
									<CssParameter name="fill">#a8dbd6</CssParameter>
								</Fill>
							</Mark>
							<Size>10</Size>
						</Graphic>
					</PointSymbolizer>
					</Rule>
					<!-- HUOM! Label otettu pois, sekoittaa näkymää jos on mukana. -->			
					
				
				<Rule>
					<Title>Merkittävä rakennettu kulttuuriympäristö, maakunnallinen</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>113</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#73B2FF</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#000000</CssParameter>
									<CssParameter name="stroke-width">0.5</CssParameter>
								</Stroke>
							</Mark>
							<Size>12</Size>
						</Graphic>
					</PointSymbolizer>
					</Rule>
					
					
					<Rule>
					<Title>Merkittävä rakennettu kulttuuriympäristö, maakunnallinen label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>113</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>90000</MaxScaleDenominator>
 					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">10</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.0</AnchorPointX>
									<AnchorPointY>0.0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>4</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#000000</CssParameter>
						</Fill>
					<VendorOption name="partials">true</VendorOption></TextSymbolizer>
				</Rule>
				<Rule>
					<Title>Merkittävä rakennettu kulttuuriympäristö, valtakunnallinen label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>114</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>90000</MaxScaleDenominator>
 					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">10</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.0</AnchorPointX>
									<AnchorPointY>0.0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>4</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#000000</CssParameter>
						</Fill>
					<VendorOption name="partials">true</VendorOption></TextSymbolizer>
				</Rule>
				
				
				<Rule>
					<Title>Merkittävä rakennettu kulttuuriympäristö, valtakunnallinen</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>114</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#73B2FF</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#000000</CssParameter>
									<CssParameter name="stroke-width">0.5</CssParameter>
								</Stroke>
							</Mark>
							<Size>12</Size>
						</Graphic>
					</PointSymbolizer>
					</Rule>
					<!-- HUOM! sekoittaa näkymää jos label tällä merkillä. -->					
					
				
				<Rule>
					<Title>Muinaismuistokohde</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>621</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>square</WellKnownName>
								<Fill>
									<CssParameter name="fill">#000000</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#000000</CssParameter>
									<CssParameter name="stroke-width">1.333333</CssParameter>
								</Stroke>
							</Mark>
							<Size>6</Size>
						</Graphic>
					</PointSymbolizer>
					</Rule>
					<Rule>
					<Title>Muinaismuistokohde label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>621</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>90000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">10</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.0</AnchorPointX>
									<AnchorPointY>0.0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>4</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#000000</CssParameter>
						</Fill>
					<VendorOption name="partials">true</VendorOption></TextSymbolizer>
				</Rule>	

				<Rule>
					<Title>Virkistys- ja matkailukohde</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>63</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>triangle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#54a81c</CssParameter>
								</Fill>
							</Mark>
							<Size>14</Size>
						</Graphic>
					</PointSymbolizer>
				</Rule>	

				<Rule>
					<Title>Joukkoliikenteen vaihtopaikka</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>106</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>triangle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#806a94</CssParameter>
								</Fill>
							</Mark>
							<Size>14</Size>
						</Graphic>
					</PointSymbolizer>
				</Rule>	

				<Rule>
					<Title>Liityntäpysäköintipaikka</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>107</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>triangle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#4281b9</CssParameter>
								</Fill>
							</Mark>
							<Size>14</Size>
							<Rotation>180</Rotation>
						</Graphic>
					</PointSymbolizer>
				</Rule>	

				<Rule>
					<Title>Liikenneterminaali/julkisen liikenteen vaihtopaikka/matkakeskus</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>64</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#000000</CssParameter>
								</Fill>
							</Mark>
							<Size>10</Size>
						</Graphic>
					</PointSymbolizer>
					</Rule>
					<Rule>
					<Title>Liikenneterminaali/julkisen liikenteen vaihtopaikka/matkakeskus label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>64</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>90000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">10</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.0</AnchorPointX>
									<AnchorPointY>0.0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>4</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#000000</CssParameter>
						</Fill>
					<VendorOption name="partials">true</VendorOption></TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Rautatieliikenteen alue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>65</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#000000</CssParameter>
								</Fill>
							</Mark>
							<Size>10</Size>
						</Graphic>
					</PointSymbolizer>
					</Rule>
					<Rule>
					<Title>Rautatieliikenteen alue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>65</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>90000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">10</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.0</AnchorPointX>
									<AnchorPointY>0.0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>4</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#000000</CssParameter>
						</Fill>
					<VendorOption name="partials">true</VendorOption></TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Lentoasema tai -kenttä</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>66</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#000000</CssParameter>
								</Fill>
							</Mark>
							<Size>10</Size>
						</Graphic>
					</PointSymbolizer>
					</Rule>
					<Rule>
					<Title>Lentoasema tai -kenttä label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>66</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>90000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">10</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.0</AnchorPointX>
									<AnchorPointY>0.0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>4</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#000000</CssParameter>
						</Fill>
					<VendorOption name="partials">true</VendorOption></TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Satama-alue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>67</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#000000</CssParameter>
								</Fill>
							</Mark>
							<Size>10</Size>
						</Graphic>
					</PointSymbolizer>
					</Rule>
					<Rule>
					<Title>Satama-alue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>67</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>90000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">10</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.0</AnchorPointX>
									<AnchorPointY>0.0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>4</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#000000</CssParameter>
						</Fill>
					<VendorOption name="partials">true</VendorOption></TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Venesatama</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>68</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#000000</CssParameter>
								</Fill>
							</Mark>
							<Size>8</Size>
						</Graphic>
					</PointSymbolizer>					
					</Rule>
					
					<Rule>
					<Title>Venesatama label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>68</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>90000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">10</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.0</AnchorPointX>
									<AnchorPointY>0.0</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>4</DisplacementX>
									<DisplacementY>5</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
						<Fill>
							<CssParameter name="fill">#000000</CssParameter>
						</Fill>
					<VendorOption name="partials">true</VendorOption></TextSymbolizer>
				</Rule>
				
				<Rule>
					<Title>Liittymä, olemassaoleva</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>74</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#FFFFFF</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#000000</CssParameter>
									<CssParameter name="stroke-width">2</CssParameter> 
								</Stroke>
							</Mark>
							<Size>12</Size>
						</Graphic>
					</PointSymbolizer>
				</Rule>
				
				<Rule>
					<Title>Liittymä, uusi</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>741</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#FFFFFF</CssParameter>
								</Fill>
								<Stroke>
									<CssParameter name="stroke">#f40a27</CssParameter>
									<CssParameter name="stroke-width">2</CssParameter> 
								</Stroke>
							</Mark>
							<Size>12</Size>
						</Graphic>
					</PointSymbolizer>
				</Rule>
				<Rule>
					<Title>Liikennepaikka</Title>
					<ogc:Filter>                      
                      <ogc:And>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>781</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        <ogc:PropertyIsNotEqualTo>
							<ogc:PropertyName>merkLisati</ogc:PropertyName>
							<ogc:Literal>uusi</ogc:Literal>
						</ogc:PropertyIsNotEqualTo>                       
                        </ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>				
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>ttf://Ykaava#0x63</WellKnownName>
								<Fill>
									<CssParameter name="fill">#000000</CssParameter>
								</Fill>
							</Mark>
							<Size>12</Size>							
						</Graphic>
					</PointSymbolizer>				
				</Rule>	
				<Rule>
					<Title>Liikennepaikka, uusi</Title>
					<ogc:Filter>                      
                      <ogc:And>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>781</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        <ogc:PropertyIsEqualTo>
							<ogc:PropertyName>merkLisati</ogc:PropertyName>
							<ogc:Literal>uusi</ogc:Literal>
						</ogc:PropertyIsEqualTo>                       
                        </ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>				
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>ttf://Ykaava#0x63</WellKnownName>
								<Fill>
									<CssParameter name="fill">#FF0000</CssParameter>
								</Fill>
							</Mark>
							<Size>12</Size>							
						</Graphic>
					</PointSymbolizer>				
				</Rule>								

				<!-- Muu kohdemerkinnät -->				
				
				<Rule>
					<Title>Muu kohdemerkintä, Uusi päärata ja ohjeellinen liikennepaikka</Title>
					<ogc:Filter>
                      <ogc:And>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>203</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        <ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>LP</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        </ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>				
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#FF0000</CssParameter>
								</Fill>
							</Mark>
							<Size>10</Size>
						</Graphic>
					</PointSymbolizer>					
				</Rule>
				
				<Rule>
					<Title>Muu kohdemerkintä, Taajamarakenteen laajenemissuunta</Title>
					<ogc:Filter>
                      <ogc:And>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>203</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        <ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>yk</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        </ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>				
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#FF0000</CssParameter>
								</Fill>
							</Mark>
							<Size>10</Size>
						</Graphic>
					</PointSymbolizer>					
				</Rule>
				
				<Rule>
					<Title>Muu kohdemerkintä, Maakaasun siirtoputken yhteystarve</Title>
					<ogc:Filter>
                      <ogc:And>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>203</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        <ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>mkyht</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        </ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>				
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#FF0000</CssParameter>
								</Fill>
							</Mark>
							<Size>10</Size>
						</Graphic>
					</PointSymbolizer>					
				</Rule>
				
				<Rule>
					<Title>Muu kohdemerkintä, Moottoriurheilurata</Title>
					<ogc:Filter>
                      <ogc:And>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>203</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        <ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>mr</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        </ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>				
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#FF0000</CssParameter>
								</Fill>
							</Mark>
							<Size>10</Size>
						</Graphic>
					</PointSymbolizer>					
				</Rule>
				
				<Rule>
					<Title>Muu kohdemerkintä, Yhdyskuntateknisen huollon alue, ohjeellinen vaihtoehtoinen sijainti</Title>
					<ogc:Filter>
                      <ogc:And>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>203</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        <ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>et-v</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        </ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>				
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#FF0000</CssParameter>
								</Fill>
							</Mark>
							<Size>10</Size>
						</Graphic>
					</PointSymbolizer>					
				</Rule>
				
				
				<Rule>
					<Title>Muu kohdemerkintä, Tunneli</Title>
					<ogc:Filter>
                      <ogc:And>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>203</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        <ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>tunneli</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        </ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>				
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#FF0000</CssParameter>
								</Fill>
							</Mark>
							<Size>10</Size>
						</Graphic>
					</PointSymbolizer>					
				</Rule>		
				

				<Rule>
					<Title>Muu kohdemerkintä</Title>
					<ogc:Filter>                      
                      <ogc:And>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>203</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        <ogc:PropertyIsNotEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>K</ogc:Literal>
						</ogc:PropertyIsNotEqualTo>
                        <ogc:PropertyIsNotEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>LP</ogc:Literal>
						</ogc:PropertyIsNotEqualTo>
                        <ogc:PropertyIsNotEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>yk</ogc:Literal>
						</ogc:PropertyIsNotEqualTo>
                        <ogc:PropertyIsNotEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>mkyht</ogc:Literal>
						</ogc:PropertyIsNotEqualTo>
                        <ogc:PropertyIsNotEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>mr</ogc:Literal>
						</ogc:PropertyIsNotEqualTo>
                        <ogc:PropertyIsNotEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>et-v</ogc:Literal>
						</ogc:PropertyIsNotEqualTo>
                        <ogc:PropertyIsNotEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>tunneli</ogc:Literal>
						</ogc:PropertyIsNotEqualTo>
                        </ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>45000</MinScaleDenominator>   <MaxScaleDenominator>450000</MaxScaleDenominator>				
					<PointSymbolizer>
						<Graphic>
							<Mark>
								<WellKnownName>circle</WellKnownName>
								<Fill>
									<CssParameter name="fill">#000000</CssParameter>
								</Fill>
							</Mark>
							<Size>10</Size>
						</Graphic>
					</PointSymbolizer>					
				</Rule>	
              
			</FeatureTypeStyle>
		</UserStyle>
	</NamedLayer>
</StyledLayerDescriptor>
