<?xml version="1.0" encoding="UTF-8"?>
<StyledLayerDescriptor 
  version="1.0.0"
  xsi:schemaLocation="http://www.opengis.net/sld http://schemas.opengis.net/sld/1.0.0/StyledLayerDescriptor.xsd"
  xmlns="http://www.opengis.net/sld" 
  xmlns:ogc="http://www.opengis.net/ogc"
  xmlns:xlink="http://www.w3.org/1999/xlink" 
  xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">

	<NamedLayer>
		<Name>hame_alueet</Name>
		<UserStyle>
			<Name>hame_alueet</Name>
			<Title>Aluemaiset merkinnät ja niiden labelit</Title>
			<FeatureTypeStyle>

				<!-- Kehittämisperiaatemerkinnät -->

				<Rule>
					<Title>Kaupunkikehittämisen kohdealue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>1</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				 <MaxScaleDenominator>2990000</MaxScaleDenominator>				
					<PolygonSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#c00000</CssParameter>
							<CssParameter name="stroke-width">2.666667</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>
				
				<Rule>
					<Title>Kaupunkikehittämisen kohdealue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>1</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>					
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Maaseudun kehittämisen kohdealue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>2</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#d38d5f</CssParameter>
							<CssParameter name="stroke-width">2.666667</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>

				<Rule>
					<Title>Maaseudun kehittämisen kohdealue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>2</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>						

				<Rule>
					<Title>Matkailun vetovoima-alue / matkailun ja virkistyksen kehittämisen kohdealue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>3</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#54a81c</CssParameter>
							<CssParameter name="stroke-width">2.666667</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>	

				<Rule>
					<Title>Matkailun vetovoima-alue / matkailun ja virkistyksen kehittämisen kohdealue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>3</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>	

				<Rule>
					<Title>Selvitysalue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>4</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
				<MinScaleDenominator>49000</MinScaleDenominator>  <MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#002673</CssParameter>
							<CssParameter name="stroke-width">2.666667</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>

				<Rule>
					<Title>Selvitysalue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>4</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>	
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>					

				<Rule>
					<Title>Yhdyskuntarakenteen eheyttämistarve</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>6</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
				<MinScaleDenominator>49000</MinScaleDenominator>  <MaxScaleDenominator>2990000</MaxScaleDenominator>				
					<PolygonSymbolizer>
						<Stroke>
							<GraphicStroke>
								<Graphic>
									<Mark>
										<WellKnownName>shape://carrow</WellKnownName>
										<Fill>
											<CssParameter name="fill">#000000</CssParameter>
										</Fill>
										<Stroke>
											<CssParameter name="stroke">#000000</CssParameter>
											<CssParameter name="stroke-width">2</CssParameter>
										</Stroke>
									</Mark>
									<Size>15</Size>
									<Rotation>90</Rotation>
								</Graphic>
							</GraphicStroke>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>
				

				<!-- Osa-alueiden erityisominaisuuksia ilmaisevat merkinnät -->

				<Rule>
					<Title>Arvokas maisema-alue (maakunnallinen)</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>111</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
				<MinScaleDenominator>49000</MinScaleDenominator>  <MaxScaleDenominator>2990000</MaxScaleDenominator>				
					<PolygonSymbolizer>
						<Fill>
							<GraphicFill>
								<Graphic>
									<Mark>
										<WellKnownName>shape://horline</WellKnownName>
										<Stroke>
											<CssParameter name="stroke">#a8dbd6</CssParameter>
											<CssParameter name="stroke-width">1.333333</CssParameter>
										</Stroke>
									</Mark>
									<Size>4.0</Size>
								</Graphic>
							</GraphicFill>
						</Fill>
					</PolygonSymbolizer>
				</Rule>

				<Rule>
					<Title>Arvokas maisema-alue (valtakunnallinen)</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>112</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
				<MinScaleDenominator>49000</MinScaleDenominator>  <MaxScaleDenominator>2990000</MaxScaleDenominator>				
					<PolygonSymbolizer>
						<Fill>
							<GraphicFill>
								<Graphic>
									<Mark>
										<WellKnownName>shape://horline</WellKnownName>
										<Stroke>
											<CssParameter name="stroke">#a8dbd6</CssParameter>
											<CssParameter name="stroke-width">1.333333</CssParameter>
										</Stroke>
									</Mark>
									<Size>4.0</Size>
								</Graphic>
							</GraphicFill>
						</Fill>
						<Stroke>
							<CssParameter name="stroke">#a8dbd6</CssParameter>
							<CssParameter name="stroke-width">1.333333</CssParameter>
						</Stroke>			
					</PolygonSymbolizer>
				</Rule>

				<Rule>
					<Title>Merkittävä rakennettu kulttuuriympäristö (maakunnallinen)</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>113</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
				<MinScaleDenominator>49000</MinScaleDenominator>  <MaxScaleDenominator>2990000</MaxScaleDenominator>				
					<PolygonSymbolizer>
						<Fill>
							<GraphicFill>
								<Graphic>
									<Mark>
										<WellKnownName>shape://horline</WellKnownName>
										<Stroke>
											<CssParameter name="stroke">#73b2ff</CssParameter>
											<CssParameter name="stroke-width">1.333333</CssParameter>
										</Stroke>
									</Mark>
									<Size>4.0</Size>
								</Graphic>
							</GraphicFill>
						</Fill>
					</PolygonSymbolizer>
				</Rule>
				
				<Rule>
					<Title>Merkittävä rakennettu kulttuuriympäristö (valtakunnallinen)</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>114</ogc:Literal>							
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
				<MinScaleDenominator>49000</MinScaleDenominator>  <MaxScaleDenominator>2990000</MaxScaleDenominator>				
					<PolygonSymbolizer>
						<Fill>
							<GraphicFill>
								<Graphic>
									<Mark>
										<WellKnownName>shape://horline</WellKnownName>
										<Stroke>
											<CssParameter name="stroke">#73b2ff</CssParameter>
											<CssParameter name="stroke-width">1.333333</CssParameter>
										</Stroke>
									</Mark>
									<Size>4.0</Size>
								</Graphic>
							</GraphicFill>
						</Fill>
						<Stroke>
							<CssParameter name="stroke">#73b2ff</CssParameter>
							<CssParameter name="stroke-width">1.333333</CssParameter>
						</Stroke>	
					</PolygonSymbolizer>
				</Rule>

				<Rule>
					<Title>Arvokas harjualue tai muu geologinen muodostuma</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>12</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
				<MinScaleDenominator>49000</MinScaleDenominator>  <MaxScaleDenominator>2990000</MaxScaleDenominator>				
					<PolygonSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#000000</CssParameter>
							<CssParameter name="stroke-width">2</CssParameter>
							<CssParameter name="stroke-dasharray">4 2 1 2</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>

				<Rule>
					<Title>Arvokas harjualue tai muu geologinen muodostuma label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>12</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>					
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>					

				<Rule>
					<Title>Tärkeä vedenhankintaan soveltuva pohjavesialue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>13</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
				<MinScaleDenominator>49000</MinScaleDenominator>  <MaxScaleDenominator>2990000</MaxScaleDenominator>				
					<PolygonSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#003ebe</CssParameter>
							<CssParameter name="stroke-width">2</CssParameter>
							<CssParameter name="stroke-dasharray">4 2 1 2</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>	
				
				<Rule>
					<Title>Tärkeä vedenhankintaan soveltuva pohjavesialue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>13</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>					
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>
				
				<Rule>
					<Title>Natura 2000-verkostoon kuuluva tai ehdotettu alue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>14</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Stroke>
							<GraphicStroke>
								<Graphic>
									<Mark>
										<WellKnownName>circle</WellKnownName>
										<Fill>
											<CssParameter name="fill">#9c9c9c</CssParameter>
										</Fill>
									</Mark>
									<Size>4</Size>
								</Graphic>
							</GraphicStroke>
							<CssParameter name="stroke-dasharray">12 4</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
					<PolygonSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#9c9c9c</CssParameter>
							<CssParameter name="stroke-width">0.4</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>	
							
				<Rule>
					<Title>Natura 2000-verkostoon kuuluva tai ehdotettu alue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>14</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							nat
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>	
				
				<Rule>
					<Title>Luonnon monimuotoisuuden kannalta erityisen tärkeä alue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>15</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
				<MinScaleDenominator>49000</MinScaleDenominator>  <MaxScaleDenominator>2990000</MaxScaleDenominator>				
					<PolygonSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#54a81c</CssParameter>
							<CssParameter name="stroke-width">2</CssParameter>
							<CssParameter name="stroke-dasharray">4 2 1 2</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>			

				<Rule>
					<Title>Luonnon monimuotoisuuden kannalta erityisen tärkeä alue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>15</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>					
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>
				
				<Rule>
					<Title>Melualue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>18</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
				<MinScaleDenominator>49000</MinScaleDenominator>  <MaxScaleDenominator>2990000</MaxScaleDenominator>				
					<PolygonSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#000000</CssParameter>
							<CssParameter name="stroke-width">2</CssParameter>
							<CssParameter name="stroke-dasharray">4 2 1 2</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>

				<Rule>
					<Title>Melualue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>18</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>					
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>				

				<Rule>
					<Title>Vaara-alue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>19</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
				<MinScaleDenominator>49000</MinScaleDenominator>  <MaxScaleDenominator>2990000</MaxScaleDenominator>				
					<PolygonSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#6e6e6e</CssParameter>
							<CssParameter name="stroke-width">2</CssParameter>
							<CssParameter name="stroke-dasharray">4 2 1 2</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>

				<Rule>
					<Title>Vaara-alue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>19</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>					
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>					

				<Rule>
					<Title>Suojavyöhyke</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>20</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
				<MinScaleDenominator>49000</MinScaleDenominator>  <MaxScaleDenominator>2990000</MaxScaleDenominator>				
					<PolygonSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#6e6e6e</CssParameter>
							<CssParameter name="stroke-width">2</CssParameter>
							<CssParameter name="stroke-dasharray">4 2 1 2</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>

				<Rule>
					<Title>Suojavyöhyke label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>20</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>					

				<Rule>
					<Title>Tiivistettävä alue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>93</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
				<MinScaleDenominator>49000</MinScaleDenominator>  <MaxScaleDenominator>2990000</MaxScaleDenominator>				
					<PolygonSymbolizer>
						<Fill>
							<GraphicFill>
								<Graphic>
									<Mark>
										<WellKnownName>shape://plus</WellKnownName>
										<Stroke>
											<CssParameter name="stroke">#a87000</CssParameter>
											<CssParameter name="stroke-width">1.333333</CssParameter>
										</Stroke>
									</Mark>
									<Size>5</Size>
								</Graphic>
							</GraphicFill>
						</Fill>
					</PolygonSymbolizer>
				</Rule>

				<Rule>
					<Title>Reservialue</Title>
					<ogc:Filter>
						<ogc:And>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
								<ogc:Literal>94</ogc:Literal>
							</ogc:PropertyIsEqualTo>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
								<ogc:Literal>Ar</ogc:Literal>
							</ogc:PropertyIsEqualTo>
						</ogc:And>
					</ogc:Filter>
				<MinScaleDenominator>49000</MinScaleDenominator>  <MaxScaleDenominator>2990000</MaxScaleDenominator>				
					<PolygonSymbolizer>
						<Fill>
							<GraphicFill>
								<Graphic>
									<Mark>
										<WellKnownName>shape://vertline</WellKnownName>
										<Stroke>
											<!-- Aluevarausmerkinnän mukainen väri! -->
											<CssParameter name="stroke">#DFBF8F</CssParameter>
											<CssParameter name="stroke-width">2.666667</CssParameter>
										</Stroke>
									</Mark>
									<Size>5</Size>
								</Graphic>
							</GraphicFill>
						</Fill>
					</PolygonSymbolizer>
				</Rule>
				
				<Rule>
					<Title>Reservialue label</Title>
					<ogc:Filter>
						<ogc:And>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
								<ogc:Literal>94</ogc:Literal>
							</ogc:PropertyIsEqualTo>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
								<ogc:Literal>Ar</ogc:Literal>
							</ogc:PropertyIsEqualTo>
						</ogc:And>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>					
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Kansallinen kaupunkipuisto</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>17</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
				<MinScaleDenominator>49000</MinScaleDenominator>  <MaxScaleDenominator>2990000</MaxScaleDenominator>				
					<PolygonSymbolizer>
						<Fill>
							<GraphicFill>
								<Graphic>
									<Mark>
										<WellKnownName>shape://horline</WellKnownName>
										<Stroke>
											<CssParameter name="stroke">#006d00</CssParameter>
											<CssParameter name="stroke-width">1.333333</CssParameter>
										</Stroke>
									</Mark>
									<Size>4.0</Size>
								</Graphic>
							</GraphicFill>
						</Fill>
						<Stroke>
							<CssParameter name="stroke">#006d00</CssParameter>
							<CssParameter name="stroke-width">1.333333</CssParameter>
						</Stroke>			
					</PolygonSymbolizer>
				</Rule>

				<Rule>
					<Title>Unescon maailmanperintökohde</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>16</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
				<MinScaleDenominator>49000</MinScaleDenominator>  <MaxScaleDenominator>2990000</MaxScaleDenominator>				
					<PolygonSymbolizer>
						<Stroke>
							<GraphicStroke>
								<Graphic>
									<Mark>
										<WellKnownName>circle</WellKnownName>
										<Fill>
											<CssParameter name="fill">#000000</CssParameter>
										</Fill>
									</Mark>
									<Size>6</Size>
								</Graphic>
							</GraphicStroke>
							<CssParameter name="stroke-dasharray">6.666667 8</CssParameter>

							<CssParameter name="stroke">#000000</CssParameter>
							<CssParameter name="stroke-width">2.666667</CssParameter> 
						</Stroke>
					</PolygonSymbolizer>
				</Rule>		

				<Rule>
					<Title>Ekologinen kehittämisvyöhyke / kehittämisen kohdealue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>300</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#54A81C</CssParameter>
							<CssParameter name="stroke-width">7</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>

				<Rule>
					<Title>Kaupan / palveluiden kehittämisvyöhyke</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>301</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#ED9E4F</CssParameter>
							<CssParameter name="stroke-width">4</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>
				
				<Rule>
					<Title>Taajamatoimintojen kehittämisvyöhyke</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>302</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#DFBF8F</CssParameter>
							<CssParameter name="stroke-width">7</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>		

				<Rule>
					<Title>Liikenteen kehittämisvyöhyke</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>303</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#9B4F00</CssParameter>
							<CssParameter name="stroke-width">7</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>
				
				<Rule>
					<Title>Keskutatoimintojen kehittämisvyöhyke</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>304</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#CC0A2E</CssParameter>
							<CssParameter name="stroke-width">7</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>
				
				<Rule>
					<Title>Teollisuuden ja logistiikan kehittämisvyöhyke</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>305</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#8F808F</CssParameter>
							<CssParameter name="stroke-width">7</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>

				<Rule>
					<Title>Energiahuoltoalue/uusiutuvan energian ja bioteollisuuden kehittämisalue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>306</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#FF73DF</CssParameter>
							<CssParameter name="stroke-width">7</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>
				
				<Rule>
					<Title>Tärkeä vedenhankintaan soveltuva pintavesialue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>307</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
				<MinScaleDenominator>49000</MinScaleDenominator>  <MaxScaleDenominator>2990000</MaxScaleDenominator>				
					<PolygonSymbolizer>
						<Fill>
							<GraphicFill>
								<Graphic>
									<Mark>
										<WellKnownName>shape://slash</WellKnownName>
										<Stroke>
											<CssParameter name="stroke">#4281b9</CssParameter>
											<CssParameter name="stroke-width">1.333333</CssParameter>
										</Stroke>
									</Mark>
									<Size>4.0</Size>
								</Graphic>
							</GraphicFill>
						</Fill>
					</PolygonSymbolizer>
					
					 <PolygonSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#4281b9</CssParameter>
							<CssParameter name="stroke-width">2</CssParameter>
							<CssParameter name="stroke-linejoin">bevel</CssParameter>
							<CssParameter name="stroke-dasharray">4 2 1 2</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>
				
				<Rule>
					<Title>Arvokas vesialue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>308</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
				<MinScaleDenominator>49000</MinScaleDenominator>  <MaxScaleDenominator>2990000</MaxScaleDenominator>				
					<PolygonSymbolizer>
						<Fill>
							<GraphicFill>
								<Graphic>
									<Mark>
										<WellKnownName>shape://slash</WellKnownName>
										<Stroke>
											<CssParameter name="stroke">#7CB9E8</CssParameter>
											<CssParameter name="stroke-width">1.333333</CssParameter>
										</Stroke>
									</Mark>
									<Size>4.0</Size>
								</Graphic>
							</GraphicFill>
						</Fill>
					</PolygonSymbolizer>
					
					 <PolygonSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#7CB9E8</CssParameter>
							<CssParameter name="stroke-width">2</CssParameter>
							<CssParameter name="stroke-linejoin">bevel</CssParameter>
							<CssParameter name="stroke-dasharray">4 2 1 2</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>
				
				<Rule>
					<Title>Konsultointivyöhyke</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>310</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
				<MinScaleDenominator>49000</MinScaleDenominator>  <MaxScaleDenominator>2990000</MaxScaleDenominator>				
					<PolygonSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#9c9c9c</CssParameter>
							<CssParameter name="stroke-width">2</CssParameter>
							<CssParameter name="stroke-dasharray">4 2 1 2</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>				

				<!-- Aluevarausmerkinnät -->

				<Rule>
					<Title>Taajamatoimintojen alue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>23</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Fill>
							<CssParameter name="fill">#dfbf8f</CssParameter>
						</Fill>
						<Stroke>
							<CssParameter name="stroke">#9c9c9c</CssParameter>
							<CssParameter name="stroke-width">0.533333</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>

				<Rule>
					<Title>Taajamatoimintojen alue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>23</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Asuntovaltainen alue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>24</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Fill>
							<CssParameter name="fill">#dfbf8f</CssParameter>
						</Fill>
						<Stroke>
							<CssParameter name="stroke">#9c9c9c</CssParameter>
							<CssParameter name="stroke-width">0.533333</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>
				
				<Rule>
					<Title>Asuntovaltainen alue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>24</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>	

				<Rule>
					<Title>Keskustatoimintojen alue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>25</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Fill>
							<CssParameter name="fill">#cc0a2e</CssParameter>
						</Fill>
						<Stroke>
							<CssParameter name="stroke">#9c9c9c</CssParameter>
							<CssParameter name="stroke-width">0.533333</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>
				
				<Rule>
					<Title>Keskustatoimintojen alue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>25</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>	
				
				<Rule>
					<Title>Keskustatoimintojen alakeskus</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>86</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Fill>
							<CssParameter name="fill">#cc0a2e</CssParameter>
						</Fill>
						<Stroke>
							<CssParameter name="stroke">#9c9c9c</CssParameter>
							<CssParameter name="stroke-width">0.533333</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>
				
				<Rule>
					<Title>Keskustatoimintojen alakeskus label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>86</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>			
				
				<Rule>
					<Title>Palvelujen alue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>26</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Fill>
							<CssParameter name="fill">#ed9e4f</CssParameter>
						</Fill>
						<Stroke>
							<CssParameter name="stroke">#9c9c9c</CssParameter>
							<CssParameter name="stroke-width">0.533333</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>	
				
				<Rule>
					<Title>Palvelujen alue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>26</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Kaupallisten palvelujen alue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>87</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Fill>
							<CssParameter name="fill">#ed9e4f</CssParameter>
						</Fill>
						<Stroke>
							<CssParameter name="stroke">#9c9c9c</CssParameter>
							<CssParameter name="stroke-width">0.533333</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>
				
				<Rule>
					<Title>Kaupallisten palvelujen alue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>87</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Työpaikka-alue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>27</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Fill>
							<CssParameter name="fill">#fa738c</CssParameter>
						</Fill>
						<Stroke>
							<CssParameter name="stroke">#9c9c9c</CssParameter>
							<CssParameter name="stroke-width">0.533333</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>

				<Rule>
					<Title>Työpaikka-alue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>27</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>						

				<Rule>
					<Title>Teollisuus- ja varastoalue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>28</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Fill>
							<CssParameter name="fill">#bababa</CssParameter>
						</Fill>
						<Stroke>
							<CssParameter name="stroke">#9c9c9c</CssParameter>
							<CssParameter name="stroke-width">0.533333</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>

				<Rule>
					<Title>Teollisuus- ja varastoalue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>28</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>								

				<Rule>
					<Title>Ympäristövaikutuksiltaan merkittävien teollisuustoimintojen alue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>29</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Fill>
							<CssParameter name="fill">#bababa</CssParameter>
						</Fill>
						<Stroke>
							<CssParameter name="stroke">#9c9c9c</CssParameter>
							<CssParameter name="stroke-width">0.533333</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>

				<Rule>
					<Title>Ympäristövaikutuksiltaan merkittävien teollisuustoimintojen alue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>29</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>					

				<Rule>
					<Title>Teollisuus- ja varastoalue, jolla on/jolle saa sijoittaa merkittävän, vaarallisia kemikaaleja valmistavan tai varastoivan laitoksen</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>30</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Fill>
							<CssParameter name="fill">#bababa</CssParameter>
						</Fill>
						<Stroke>
							<CssParameter name="stroke">#9c9c9c</CssParameter>
							<CssParameter name="stroke-width">0.533333</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>	

				<Rule>
					<Title>Teollisuus- ja varastoalue, jolla on/jolle saa sijoittaa merkittävän, vaarallisia kemikaaleja valmistavan tai varastoivan laitoksen label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>30</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>	
				
				<Rule>
					<Title>Virkistysalue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>31</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Fill>
							<CssParameter name="fill">#54a81c</CssParameter>
						</Fill>
						<Stroke>
							<CssParameter name="stroke">#9c9c9c</CssParameter>
							<CssParameter name="stroke-width">0.533333</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>
				
				<Rule>
					<Title>Virkistysalue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>31</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Loma- ja matkailualue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>32</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Fill>
							<CssParameter name="fill">#ffd12b</CssParameter>
						</Fill>
						<Stroke>
							<CssParameter name="stroke">#9c9c9c</CssParameter>
							<CssParameter name="stroke-width">0.533333</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>

				<Rule>
					<Title>Loma- ja matkailualue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>32</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>
				
				<Rule>
					<Title>Loma-asuntoalue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>33</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Fill>
							<CssParameter name="fill">#ffd12b</CssParameter>
						</Fill>
						<Stroke>
							<CssParameter name="stroke">#9c9c9c</CssParameter>
							<CssParameter name="stroke-width">0.533333</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>
				
				<Rule>
					<Title>Loma-asuntoalue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>33</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>
				
				<Rule>
					<Title>Matkailupalvelujen alue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>34</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
				<MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Fill>
							<CssParameter name="fill">#ffd12b</CssParameter>
						</Fill>
						<Stroke>
							<CssParameter name="stroke">#9c9c9c</CssParameter>
							<CssParameter name="stroke-width">0.533333</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>
				
				<Rule>
					<Title>Matkailupalvelujen alue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>34</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>
				
				<Rule>
					<Title>Liikennealue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>35</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#f40a27</CssParameter>
							<CssParameter name="stroke-width">4</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>
					
				<Rule>
					<Title>Liikennealue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>35</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Maaliikenteen alue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>36</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#f40a27</CssParameter>
							<CssParameter name="stroke-width">4</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>
				
				<Rule>
					<Title>Maaliikenteen alue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>36</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>
				
				<Rule>
					<Title>Lentoliikenteen alue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>37</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#f40a27</CssParameter>
							<CssParameter name="stroke-width">4</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>

				<Rule>
					<Title>Lentoliikenteen alue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>37</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Satama-alue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>38</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#f40a27</CssParameter>
							<CssParameter name="stroke-width">4</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>

				<Rule>
					<Title>Satama-alue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>38</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>
				
				<Rule>
					<Title>Erityisalue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>39</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Fill>
							<CssParameter name="fill">#ffbee8</CssParameter>
						</Fill>
						<Stroke>
							<CssParameter name="stroke">#9c9c9c</CssParameter>
							<CssParameter name="stroke-width">0.533333</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>	
				
				<Rule>
					<Title>Erityisalue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>39</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Yhdyskuntateknisen huollon alue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>40</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Fill>
							<CssParameter name="fill">#ffbee8</CssParameter>
						</Fill>
						<Stroke>
							<CssParameter name="stroke">#9c9c9c</CssParameter>
							<CssParameter name="stroke-width">0.533333</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>	

				<Rule>
					<Title>Yhdyskuntateknisen huollon alue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>40</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Energiahuollon alue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>41</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Fill>
							<CssParameter name="fill">#ffbee8</CssParameter>
						</Fill>
						<Stroke>
							<CssParameter name="stroke">#9c9c9c</CssParameter>
							<CssParameter name="stroke-width">0.533333</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>
				
				<Rule>
					<Title>Energiahuollon alue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>41</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>			

				<Rule>
					<Title>Jätteenkäsittelyalue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>42</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Fill>
							<CssParameter name="fill">#ffbee8</CssParameter>
						</Fill>
						<Stroke>
							<CssParameter name="stroke">#9c9c9c</CssParameter>
							<CssParameter name="stroke-width">0.533333</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>	

				<Rule>
					<Title>Jätteenkäsittelyalue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>42</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Maa-ainesten ottoalue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>43</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Fill>
							<CssParameter name="fill">#ffbee8</CssParameter>
						</Fill>
						<Stroke>
							<CssParameter name="stroke">#9c9c9c</CssParameter>
							<CssParameter name="stroke-width">0.533333</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>			

				<Rule>
					<Title>Maa-ainesten ottoalue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>43</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Turpeenottoalue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>88</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Fill>
							<CssParameter name="fill">#ffbee8</CssParameter>
						</Fill>
						<Stroke>
							<CssParameter name="stroke">#9c9c9c</CssParameter>
							<CssParameter name="stroke-width">0.533333</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>
				
				<Rule>
					<Title>Turpeenottoalue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>88</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>	

				<Rule>
					<Title>Kaivosalue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>44</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Fill>
							<CssParameter name="fill">#ffbee8</CssParameter>
						</Fill>
						<Stroke>
							<CssParameter name="stroke">#9c9c9c</CssParameter>
							<CssParameter name="stroke-width">0.533333</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>	

				<Rule>
					<Title>Kaivosalue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>44</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Puolustusvoimien alue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>45</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Fill>
							<CssParameter name="fill">#ffbee8</CssParameter>
						</Fill>
						<Stroke>
							<CssParameter name="stroke">#9c9c9c</CssParameter>
							<CssParameter name="stroke-width">0.533333</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>	

				<Rule>
					<Title>Puolustusvoimien alue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>45</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Puolustusvoimien ampuma- ja harjoitusalue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>89</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Fill>
							<CssParameter name="fill">#ffbee8</CssParameter>
						</Fill>
						<Stroke>
							<CssParameter name="stroke">#9c9c9c</CssParameter>
							<CssParameter name="stroke-width">0.533333</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>	

				<Rule>
					<Title>Puolustusvoimien ampuma- ja harjoitusalue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>89</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Suojelualue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>46</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Fill>
							<CssParameter name="fill">#a8dbd6</CssParameter>
						</Fill>
						<Stroke>
							<CssParameter name="stroke">#9c9c9c</CssParameter>
							<CssParameter name="stroke-width">0.533333</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>	

				<Rule>
					<Title>Suojelualue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>46</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>	

				<Rule>
					<Title>Luonnonsuojelualue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>47</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Fill>
							<CssParameter name="fill">#a8dbd6</CssParameter>
						</Fill>
						<Stroke>
							<CssParameter name="stroke">#9c9c9c</CssParameter>
							<CssParameter name="stroke-width">0.533333</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>

				<Rule>
					<Title>Luonnonsuojelualue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>47</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Muinaismuistoalue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>48</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Fill>
							<CssParameter name="fill">#a8dbd6</CssParameter>
						</Fill>
						<Stroke>
							<CssParameter name="stroke">#9c9c9c</CssParameter>
							<CssParameter name="stroke-width">0.533333</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>	

				<Rule>
					<Title>Muinaismuistoalue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>48</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Rakennussuojelualue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>49</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Fill>
							<CssParameter name="fill">#a8dbd6</CssParameter>
						</Fill>
						<Stroke>
							<CssParameter name="stroke">#9c9c9c</CssParameter>
							<CssParameter name="stroke-width">0.533333</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>	

				<Rule>
					<Title>Rakennussuojelualue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>49</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>	

				<Rule>
					<Title>Maa- ja metsätalousvaltainen alue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>50</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Fill>
							<CssParameter name="fill">#e8f174</CssParameter>
						</Fill>
						<Stroke>
							<CssParameter name="stroke">#9c9c9c</CssParameter>
							<CssParameter name="stroke-width">0.533333</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>

				<Rule>
					<Title>Maa- ja metsätalousvaltainen alue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>50</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>

				<Rule>
					<Title>Maatalousalue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>51</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Fill>
							<CssParameter name="fill">#fbf8a1</CssParameter>
						</Fill>
						<Stroke>
							<CssParameter name="stroke">#9c9c9c</CssParameter>
							<CssParameter name="stroke-width">0.533333</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>	

				<Rule>
					<Title>Maatalousalue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>51</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>	

				<Rule>
					<Title>Maa- ja metsätalousvaltainen alue, jolla on erityistä ulkoilun ohjaamistarvetta</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>52</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Fill>
							<CssParameter name="fill">#a8db94</CssParameter>
						</Fill>
						<Stroke>
							<CssParameter name="stroke">#9c9c9c</CssParameter>
							<CssParameter name="stroke-width">0.533333</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>	

				<Rule>
					<Title>Maa- ja metsätalousvaltainen alue, jolla on erityistä ulkoilun ohjaamistarvetta label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>52</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>	

				<Rule>
					<Title>Maa- ja metsätalousvaltainen alue, jolla on erityisiä ympäristöarvoja</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>53</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Fill>
							<CssParameter name="fill">#a8db94</CssParameter>
						</Fill>
						<Stroke>
							<CssParameter name="stroke">#9c9c9c</CssParameter>
							<CssParameter name="stroke-width">0.533333</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>	

				<Rule>
					<Title>Maa- ja metsätalousvaltainen alue, jolla on erityisiä ympäristöarvoja label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>53</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>	

				<Rule>
					<Title>Vesialue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>54</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>2990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Fill>
							<CssParameter name="fill">#bee8ff</CssParameter>
						</Fill>
						<Stroke>
							<CssParameter name="stroke">#9c9c9c</CssParameter>
							<CssParameter name="stroke-width">0.533333</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>	

				<Rule>
					<Title>Vesialue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>54</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>	

				<Rule>
					<Title>Tuulivoimaloiden alue</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>85</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
				<MinScaleDenominator>49000</MinScaleDenominator>  <MaxScaleDenominator>2990000</MaxScaleDenominator>				
					<PolygonSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#000000</CssParameter>
							<CssParameter name="stroke-width">2.666667</CssParameter>
							<CssParameter name="stroke-dasharray">5.333333 2.666667 1.333333 2.666667</CssParameter>
						</Stroke>
					</PolygonSymbolizer>
				</Rule>		

				<Rule>
					<Title>Tuulivoimaloiden alue label</Title>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>85</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
				<MaxScaleDenominator>199000</MaxScaleDenominator>
					<TextSymbolizer>
						<Label>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
						</Label>
						<Font>
							<CssParameter name="font-family">Arial</CssParameter>
							<CssParameter name="font-size">12</CssParameter>
							<CssParameter name="font-style">normal</CssParameter>
							<CssParameter name="font-weight">bold</CssParameter>
						</Font>
						<LabelPlacement>
							<PointPlacement>
								<AnchorPoint>
									<AnchorPointX>0.5</AnchorPointX>
									<AnchorPointY>0.5</AnchorPointY>
								</AnchorPoint>
								<Displacement>
									<DisplacementX>0</DisplacementX>
									<DisplacementY>0</DisplacementY>
								</Displacement>
							</PointPlacement>
						</LabelPlacement>
					</TextSymbolizer>
				</Rule>		

				<!-- Muu-merkinnät aluevaraukset - muu-merkinnöissä MaxScaleDenominator 1000000 -->

				<Rule>
					<Title>Muu aluevarausmerkintä, Liikennealue, jonka toissijainen käyttötarkoitus on taajamatoimintojen alue</Title>
					<ogc:Filter>
                      <ogc:And>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>201</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        <ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>LL/A</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        </ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>49000</MinScaleDenominator>  <MaxScaleDenominator>990000</MaxScaleDenominator>				
					<PolygonSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#c00000</CssParameter>
							<CssParameter name="stroke-width">1</CssParameter>
						</Stroke>
					</PolygonSymbolizer>					
				</Rule>

				<Rule>
					<Title>Muu aluevarausmerkintä, Ampumaradan alue tai kohde</Title>
					<ogc:Filter>
                      <ogc:And>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>201</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        <ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>EA</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        </ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>49000</MinScaleDenominator>  <MaxScaleDenominator>990000</MaxScaleDenominator>				
					<PolygonSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#c00000</CssParameter>
							<CssParameter name="stroke-width">1</CssParameter>
						</Stroke>
					</PolygonSymbolizer>					
				</Rule>
				
				<Rule>
					<Title>Muu aluevarausmerkintä, Taajamatoimintojen laajenemisalue</Title>
					<ogc:Filter>
						<ogc:And>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>201</ogc:Literal>
						</ogc:PropertyIsEqualTo>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>A</ogc:Literal>
						</ogc:PropertyIsEqualTo>
						</ogc:And>
						</ogc:Filter>
					<MinScaleDenominator>49000</MinScaleDenominator>  <MaxScaleDenominator>990000</MaxScaleDenominator>					
						<PolygonSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#c00000</CssParameter>
							<CssParameter name="stroke-width">1</CssParameter>
						</Stroke>
					</PolygonSymbolizer>					
				</Rule>
						
				<Rule>
					<Title>Muu aluevarausmerkintä, Kyläalue tai kyläkohde</Title>
					<ogc:Filter>
						<ogc:And>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>201</ogc:Literal>
						</ogc:PropertyIsEqualTo>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>AT</ogc:Literal>
						</ogc:PropertyIsEqualTo>
						</ogc:And>
						</ogc:Filter>
                  <MinScaleDenominator>49000</MinScaleDenominator> 
					<MaxScaleDenominator>990000</MaxScaleDenominator>
					<PolygonSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#c00000</CssParameter>
							<CssParameter name="stroke-width">1</CssParameter>
						</Stroke>
					</PolygonSymbolizer>					
				</Rule>
				
				<Rule>
					<Title>Muu aluevarausmerkintä, Raideliikenteeseen tukeutuva taajamatoimintojen alue</Title>
					<ogc:Filter>
						<ogc:And>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>201</ogc:Literal>
						</ogc:PropertyIsEqualTo>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>var</ogc:Literal>
						</ogc:PropertyIsEqualTo>
						</ogc:And>						
						</ogc:Filter>
					<MinScaleDenominator>49000</MinScaleDenominator>  <MaxScaleDenominator>990000</MaxScaleDenominator>					
					<PolygonSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#c00000</CssParameter>
							<CssParameter name="stroke-width">1</CssParameter>
						</Stroke>
					</PolygonSymbolizer>					
				</Rule>
              
				<Rule>
					<Title>Muu aluevarausmerkintä</Title>
					<ogc:Filter>
                      <ogc:And>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>201</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        <ogc:PropertyIsNotEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>LL/A</ogc:Literal>
						</ogc:PropertyIsNotEqualTo>
                        <ogc:PropertyIsNotEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>EA</ogc:Literal>
						</ogc:PropertyIsNotEqualTo>
                        <ogc:PropertyIsNotEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>A</ogc:Literal>
						</ogc:PropertyIsNotEqualTo>
                        <ogc:PropertyIsNotEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>AT</ogc:Literal>
						</ogc:PropertyIsNotEqualTo>
                        <ogc:PropertyIsNotEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>var</ogc:Literal>
						</ogc:PropertyIsNotEqualTo>
                        </ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>49000</MinScaleDenominator>  <MaxScaleDenominator>990000</MaxScaleDenominator>				
					<PolygonSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#444444</CssParameter>
							<CssParameter name="stroke-width">1</CssParameter>
						</Stroke>
					</PolygonSymbolizer>					
				</Rule>

								<!-- Muu-merkinnät osa-alueet - muu-merkinnöissä MaxScaleDenominator 1000000 -->

				<Rule>
					<Title>Muu kehittämisperiaatemerkintä, Raideliikenteeseen tukeutuva asemanseudun kehittämisalue</Title>
					<ogc:Filter>
                      <ogc:And>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>202</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        <ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>ake</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        </ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>49000</MinScaleDenominator>  <MaxScaleDenominator>990000</MaxScaleDenominator>				
					<PolygonSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#c00000</CssParameter>
							<CssParameter name="stroke-width">1</CssParameter>
						</Stroke>
					</PolygonSymbolizer>					
				</Rule>
				
				<Rule>
					<Title>Muu kehittämisperiaatemerkintä</Title>
					<ogc:Filter>
                      <ogc:And>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>202</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        <ogc:PropertyIsNotEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>ake</ogc:Literal>
						</ogc:PropertyIsNotEqualTo>
                        </ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>49000</MinScaleDenominator>  <MaxScaleDenominator>990000</MaxScaleDenominator>				
					<PolygonSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#444444</CssParameter>
							<CssParameter name="stroke-width">1</CssParameter>
						</Stroke>
					</PolygonSymbolizer>					
				</Rule>
				
				<Rule>
					<Title>Muu osa-aluemerkintä, Uusi päärata ja ohjeellinen liikennepaikka</Title>
					<ogc:Filter>
                      <ogc:And>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>204</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        <ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>kmk</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        </ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>49000</MinScaleDenominator>  <MaxScaleDenominator>990000</MaxScaleDenominator>				
					<PolygonSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#c00000</CssParameter>
							<CssParameter name="stroke-width">1</CssParameter>
						</Stroke>
					</PolygonSymbolizer>					
				</Rule>
				
				<Rule>
					<Title>Muu osa-aluemerkintä, Alue, jolla sijaitsee merkittäviä kiviainesvarantoja</Title>
					<ogc:Filter>
                      <ogc:And>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>204</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        <ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>kva</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        </ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>49000</MinScaleDenominator>  <MaxScaleDenominator>990000</MaxScaleDenominator>				
					<PolygonSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#c00000</CssParameter>
							<CssParameter name="stroke-width">1</CssParameter>
						</Stroke>
					</PolygonSymbolizer>					
				</Rule>

				<Rule>
					<Title>Muu osa-aluemerkintä, Kiviainestenottoalue</Title>
					<ogc:Filter>
                      <ogc:And>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>204</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        <ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>EOk</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        </ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>49000</MinScaleDenominator>  <MaxScaleDenominator>990000</MaxScaleDenominator>				
					<PolygonSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#c00000</CssParameter>
							<CssParameter name="stroke-width">1</CssParameter>
						</Stroke>
					</PolygonSymbolizer>					
				</Rule>
				
				<Rule>
					<Title>Muu osa-aluemerkintä, Kulttuuriympäristön tai maiseman vaalimisen kannalta tärkeä alue, tie tai kohde</Title>
					<ogc:Filter>
                      <ogc:And>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>204</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        <ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>ma</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        </ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>49000</MinScaleDenominator>  <MaxScaleDenominator>990000</MaxScaleDenominator>				
					<PolygonSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#c00000</CssParameter>
							<CssParameter name="stroke-width">1</CssParameter>
						</Stroke>
					</PolygonSymbolizer>					
				</Rule>				

				<Rule>
					<Title>Muu osa-aluemerkintä</Title>
					<ogc:Filter>
                      <ogc:And>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>kaavaMerkP</ogc:PropertyName>
							<ogc:Literal>204</ogc:Literal>
						</ogc:PropertyIsEqualTo>
                        <ogc:PropertyIsNotEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>kmk</ogc:Literal>
						</ogc:PropertyIsNotEqualTo>
                        <ogc:PropertyIsNotEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>kva</ogc:Literal>
						</ogc:PropertyIsNotEqualTo>
                        <ogc:PropertyIsNotEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>EOk</ogc:Literal>
						</ogc:PropertyIsNotEqualTo>
                        <ogc:PropertyIsNotEqualTo>
							<ogc:PropertyName>kaavaMerkL</ogc:PropertyName>
							<ogc:Literal>ma</ogc:Literal>
						</ogc:PropertyIsNotEqualTo>
                        </ogc:And>
					</ogc:Filter>
					<MinScaleDenominator>49000</MinScaleDenominator>  <MaxScaleDenominator>990000</MaxScaleDenominator>				
					<PolygonSymbolizer>
						<Stroke>
							<CssParameter name="stroke">#444444</CssParameter>
							<CssParameter name="stroke-width">1</CssParameter>
						</Stroke>
					</PolygonSymbolizer>					
				</Rule>
				
			</FeatureTypeStyle>
		</UserStyle>
	</NamedLayer>
</StyledLayerDescriptor>
